/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunctionBuilder;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.GrpcStatusFunction;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.grpc.ArmeriaCoroutineContextInterceptor;
import com.linecorp.armeria.server.grpc.FramedGrpcService;
import com.linecorp.armeria.server.grpc.GrpcDecoratingService;
import com.linecorp.armeria.server.grpc.GrpcHealthCheckService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.HandlerRegistry;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingOptions;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingService;
import com.linecorp.armeria.server.grpc.ProtoReflectionServiceInterceptor;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.UnframedGrpcService;
import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.protobuf.services.ProtoReflectionServiceV1;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcServiceBuilder {
    private static final Set<SerializationFormat> DEFAULT_SUPPORTED_SERIALIZATION_FORMATS;
    private static final Logger logger;
    private static final boolean USE_COROUTINE_CONTEXT_INTERCEPTOR;
    private final HandlerRegistry.Builder registryBuilder = new HandlerRegistry.Builder();
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    @Nullable
    private ProtoReflectionServiceInterceptor protoReflectionServiceInterceptor;
    @Nullable
    private GrpcExceptionHandlerFunctionBuilder exceptionMappingsBuilder;
    @Nullable
    private GrpcExceptionHandlerFunction exceptionHandler;
    @Nullable
    private ImmutableList.Builder<ServerInterceptor> interceptors;
    @Nullable
    private UnframedGrpcErrorHandler unframedGrpcErrorHandler;
    @Nullable
    private UnframedGrpcErrorHandler httpJsonTranscodingErrorHandler;
    private HttpJsonTranscodingOptions httpJsonTranscodingOptions = HttpJsonTranscodingOptions.of();
    private Set<SerializationFormat> supportedSerializationFormats = DEFAULT_SUPPORTED_SERIALIZATION_FORMATS;
    private int maxRequestMessageLength = -1;
    private int maxResponseMessageLength = -1;
    private Function<? super ServiceDescriptor, ? extends GrpcJsonMarshaller> jsonMarshallerFactory = GrpcJsonMarshaller::of;
    private boolean enableUnframedRequests;
    private boolean enableHttpJsonTranscoding;
    private boolean useBlockingTaskExecutor;
    private boolean unsafeWrapRequestBuffers;
    private boolean useClientTimeoutHeader = true;
    private boolean useMethodMarshaller;
    private boolean enableHealthCheckService;
    private boolean autoCompression;
    @Nullable
    private GrpcHealthCheckService grpcHealthCheckService;

    GrpcServiceBuilder() {
    }

    public GrpcServiceBuilder addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(Objects.requireNonNull(service, "service"), null, (List<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.of());
        return this;
    }

    public GrpcServiceBuilder addService(String path, ServerServiceDefinition service) {
        this.registryBuilder.addService(Objects.requireNonNull(path, "path"), Objects.requireNonNull(service, "service"), null, null, (List<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.of());
        return this;
    }

    public GrpcServiceBuilder addService(String path, ServerServiceDefinition service, MethodDescriptor<?, ?> methodDescriptor) {
        this.registryBuilder.addService(Objects.requireNonNull(path, "path"), Objects.requireNonNull(service, "service"), Objects.requireNonNull(methodDescriptor, "methodDescriptor"), null, (List<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.of());
        return this;
    }

    public GrpcServiceBuilder addService(BindableService bindableService) {
        return this.addService(bindableService, (Iterable<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.of());
    }

    @UnstableApi
    public GrpcServiceBuilder addService(BindableService bindableService, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        boolean hasDecorators;
        Objects.requireNonNull(bindableService, "bindableService");
        Objects.requireNonNull(decorators, "decorators");
        boolean bl = hasDecorators = !Iterables.isEmpty(decorators);
        if (bindableService instanceof ProtoReflectionService || bindableService instanceof ProtoReflectionServiceV1) {
            return this.addProtoReflectionService(hasDecorators, bindableService, null, null);
        }
        if (bindableService instanceof GrpcHealthCheckService) {
            if (hasDecorators) {
                throw new IllegalArgumentException("GrpcHealthCheckService should not be used with decorators.");
            }
            if (this.enableHealthCheckService) {
                throw new IllegalStateException("default gRPC health check service is enabled already.");
            }
            this.grpcHealthCheckService = (GrpcHealthCheckService)bindableService;
            return this;
        }
        this.registryBuilder.addService(bindableService.bindService(), bindableService.getClass(), (List<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.copyOf(decorators));
        return this;
    }

    public GrpcServiceBuilder addService(String path, BindableService bindableService) {
        return this.addService(path, bindableService, (Iterable<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.of());
    }

    @UnstableApi
    public GrpcServiceBuilder addService(String path, BindableService bindableService, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        boolean hasDecorators;
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(bindableService, "bindableService");
        Objects.requireNonNull(decorators, "decorators");
        boolean bl = hasDecorators = !Iterables.isEmpty(decorators);
        if (bindableService instanceof ProtoReflectionService || bindableService instanceof ProtoReflectionServiceV1) {
            return this.addProtoReflectionService(hasDecorators, bindableService, path, null);
        }
        this.registryBuilder.addService(path, bindableService.bindService(), null, bindableService.getClass(), (List<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.copyOf(decorators));
        return this;
    }

    public <T> GrpcServiceBuilder addService(T implementation, Function<? super T, ServerServiceDefinition> serviceDefinitionFactory) {
        return this.addService(implementation, serviceDefinitionFactory, (Iterable<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.of());
    }

    @UnstableApi
    public <T> GrpcServiceBuilder addService(T implementation, Function<? super T, ServerServiceDefinition> serviceDefinitionFactory, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        Objects.requireNonNull(implementation, "implementation");
        Objects.requireNonNull(serviceDefinitionFactory, "serviceDefinitionFactory");
        Objects.requireNonNull(decorators, "decorators");
        ServerServiceDefinition serverServiceDefinition = serviceDefinitionFactory.apply(implementation);
        Objects.requireNonNull(serverServiceDefinition, "serviceDefinitionFactory.apply() returned null");
        this.registryBuilder.addService(serverServiceDefinition, implementation.getClass(), (List<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.copyOf(decorators));
        return this;
    }

    public GrpcServiceBuilder addService(String path, BindableService bindableService, MethodDescriptor<?, ?> methodDescriptor) {
        return this.addService(path, bindableService, methodDescriptor, (Iterable<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.of());
    }

    @UnstableApi
    public GrpcServiceBuilder addService(String path, BindableService bindableService, MethodDescriptor<?, ?> methodDescriptor, Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(bindableService, "bindableService");
        Objects.requireNonNull(methodDescriptor, "methodDescriptor");
        Objects.requireNonNull(decorators, "decorators");
        if (bindableService instanceof ProtoReflectionService || bindableService instanceof ProtoReflectionServiceV1) {
            return this.addProtoReflectionService(!Iterables.isEmpty(decorators), bindableService, path, methodDescriptor);
        }
        this.registryBuilder.addService(path, bindableService.bindService(), methodDescriptor, bindableService.getClass(), (List<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.copyOf(decorators));
        return this;
    }

    private GrpcServiceBuilder addProtoReflectionService(boolean hasDecorators, BindableService protoReflectionService, @Nullable String path, @Nullable MethodDescriptor<?, ?> methodDescriptor) {
        if (hasDecorators) {
            throw new IllegalArgumentException("ProtoReflectionService should not be used with decorators.");
        }
        Preconditions.checkState((this.protoReflectionServiceInterceptor == null ? 1 : 0) != 0, (Object)"Attempting to add a ProtoReflectionService but one is already present. ProtoReflectionService must only be added once.");
        this.protoReflectionServiceInterceptor = new ProtoReflectionServiceInterceptor();
        if (protoReflectionService instanceof ProtoReflectionService) {
            logger.warn("Use {} instead of {}.", (Object)ProtoReflectionServiceV1.class.getSimpleName(), (Object)protoReflectionService);
        }
        ServerServiceDefinition intercept = ServerInterceptors.intercept((BindableService)protoReflectionService, (ServerInterceptor[])new ServerInterceptor[]{this.protoReflectionServiceInterceptor});
        return this.addProtoReflectionIntercept(intercept, path, methodDescriptor);
    }

    private GrpcServiceBuilder addProtoReflectionIntercept(ServerServiceDefinition intercept, @Nullable String path, @Nullable MethodDescriptor<?, ?> methodDescriptor) {
        if (methodDescriptor != null) {
            assert (path != null);
            return this.addService(path, intercept, methodDescriptor);
        }
        if (path == null) {
            return this.addService(intercept);
        }
        return this.addService(path, intercept);
    }

    public GrpcServiceBuilder intercept(ServerInterceptor ... interceptors) {
        Objects.requireNonNull(interceptors, "interceptors");
        return this.intercept((Iterable<? extends ServerInterceptor>)ImmutableList.copyOf((Object[])interceptors));
    }

    public GrpcServiceBuilder intercept(Iterable<? extends ServerInterceptor> interceptors) {
        Objects.requireNonNull(interceptors, "interceptors");
        this.interceptors().addAll(interceptors);
        return this;
    }

    public GrpcServiceBuilder addServices(BindableService ... bindableServices) {
        Objects.requireNonNull(bindableServices, "bindableServices");
        return this.addServices((Iterable<BindableService>)ImmutableList.copyOf((Object[])bindableServices));
    }

    public GrpcServiceBuilder addServices(Iterable<BindableService> bindableServices) {
        Objects.requireNonNull(bindableServices, "bindableServices");
        bindableServices.forEach(this::addService);
        return this;
    }

    public GrpcServiceBuilder addServiceDefinitions(ServerServiceDefinition ... services) {
        Objects.requireNonNull(services, "services");
        return this.addServiceDefinitions((Iterable<ServerServiceDefinition>)ImmutableList.copyOf((Object[])services));
    }

    public GrpcServiceBuilder addServiceDefinitions(Iterable<ServerServiceDefinition> services) {
        Objects.requireNonNull(services, "services");
        services.forEach(this::addService);
        return this;
    }

    public GrpcServiceBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = Objects.requireNonNull(registry, "registry");
        return this;
    }

    public GrpcServiceBuilder compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = Objects.requireNonNull(registry, "registry");
        return this;
    }

    public GrpcServiceBuilder supportedSerializationFormats(SerializationFormat ... formats) {
        return this.supportedSerializationFormats((Iterable<SerializationFormat>)ImmutableSet.copyOf((Object[])Objects.requireNonNull(formats, "formats")));
    }

    public GrpcServiceBuilder supportedSerializationFormats(Iterable<SerializationFormat> formats) {
        Objects.requireNonNull(formats, "formats");
        for (SerializationFormat format : formats) {
            if (GrpcSerializationFormats.isGrpc(format)) continue;
            throw new IllegalArgumentException("Not a gRPC serialization format: " + format);
        }
        this.supportedSerializationFormats = ImmutableSet.copyOf(formats);
        return this;
    }

    @Deprecated
    public GrpcServiceBuilder setMaxInboundMessageSizeBytes(int maxInboundMessageSizeBytes) {
        return this.maxRequestMessageLength(maxInboundMessageSizeBytes);
    }

    @Deprecated
    public GrpcServiceBuilder setMaxOutboundMessageSizeBytes(int maxOutboundMessageSizeBytes) {
        return this.maxResponseMessageLength(maxOutboundMessageSizeBytes);
    }

    public GrpcServiceBuilder maxRequestMessageLength(int maxRequestMessageLength) {
        Preconditions.checkArgument((maxRequestMessageLength > 0 ? 1 : 0) != 0, (String)"maxRequestMessageLength: %s (expected: > 0)", (int)maxRequestMessageLength);
        this.maxRequestMessageLength = maxRequestMessageLength;
        return this;
    }

    public GrpcServiceBuilder maxResponseMessageLength(int maxResponseMessageLength) {
        Preconditions.checkArgument((maxResponseMessageLength > 0 ? 1 : 0) != 0, (String)"maxResponseMessageLength: %s (expected: > 0)", (int)maxResponseMessageLength);
        this.maxResponseMessageLength = maxResponseMessageLength;
        return this;
    }

    public GrpcServiceBuilder enableUnframedRequests(boolean enableUnframedRequests) {
        this.enableUnframedRequests = enableUnframedRequests;
        return this;
    }

    @UnstableApi
    public GrpcServiceBuilder unframedGrpcErrorHandler(UnframedGrpcErrorHandler unframedGrpcErrorHandler) {
        Objects.requireNonNull(unframedGrpcErrorHandler, "unframedGrpcErrorHandler");
        this.unframedGrpcErrorHandler = unframedGrpcErrorHandler;
        return this;
    }

    @UnstableApi
    public GrpcServiceBuilder enableHttpJsonTranscoding(boolean enableHttpJsonTranscoding) {
        this.enableHttpJsonTranscoding = enableHttpJsonTranscoding;
        return this;
    }

    @UnstableApi
    public GrpcServiceBuilder enableHttpJsonTranscoding(HttpJsonTranscodingOptions httpJsonTranscodingOptions) {
        Objects.requireNonNull(httpJsonTranscodingOptions, "httpJsonTranscodingOptions");
        this.enableHttpJsonTranscoding = true;
        this.httpJsonTranscodingOptions = httpJsonTranscodingOptions;
        return this;
    }

    @Deprecated
    @UnstableApi
    public GrpcServiceBuilder httpJsonTranscodingErrorHandler(UnframedGrpcErrorHandler httpJsonTranscodingErrorHandler) {
        Objects.requireNonNull(httpJsonTranscodingErrorHandler, "httpJsonTranscodingErrorHandler");
        this.httpJsonTranscodingErrorHandler = httpJsonTranscodingErrorHandler;
        return this;
    }

    public GrpcServiceBuilder useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    public GrpcServiceBuilder unsafeWrapRequestBuffers(boolean unsafeWrapRequestBuffers) {
        if (unsafeWrapRequestBuffers && this.useMethodMarshaller) {
            throw new IllegalStateException("'unsafeWrapRequestBuffers' and 'useMethodMarshaller' are mutually exclusive.");
        }
        this.unsafeWrapRequestBuffers = unsafeWrapRequestBuffers;
        return this;
    }

    public GrpcServiceBuilder jsonMarshallerFactory(Function<? super ServiceDescriptor, ? extends GrpcJsonMarshaller> jsonMarshallerFactory) {
        this.jsonMarshallerFactory = Objects.requireNonNull(jsonMarshallerFactory, "jsonMarshallerFactory");
        return this;
    }

    public GrpcServiceBuilder useClientTimeoutHeader(boolean useClientTimeoutHeader) {
        this.useClientTimeoutHeader = useClientTimeoutHeader;
        return this;
    }

    public GrpcServiceBuilder enableHealthCheckService(boolean enableHealthCheckService) {
        if (this.grpcHealthCheckService != null && enableHealthCheckService) {
            throw new IllegalStateException("gRPC health check service is set already.");
        }
        this.enableHealthCheckService = enableHealthCheckService;
        return this;
    }

    @UnstableApi
    public GrpcServiceBuilder autoCompression(boolean autoCompression) {
        this.autoCompression = autoCompression;
        return this;
    }

    @UnstableApi
    public GrpcServiceBuilder useMethodMarshaller(boolean useMethodMarshaller) {
        if (this.unsafeWrapRequestBuffers && useMethodMarshaller) {
            throw new IllegalStateException("'unsafeWrapRequestBuffers' and 'useMethodMarshaller' are mutually exclusive.");
        }
        this.useMethodMarshaller = useMethodMarshaller;
        return this;
    }

    @UnstableApi
    public GrpcServiceBuilder exceptionHandler(GrpcExceptionHandlerFunction exceptionHandler) {
        Objects.requireNonNull(exceptionHandler, "exceptionHandler");
        Preconditions.checkState((this.exceptionMappingsBuilder == null ? 1 : 0) != 0, (Object)"addExceptionMapping() and exceptionHandler() are mutually exclusive.");
        this.exceptionHandler = this.exceptionHandler == null ? exceptionHandler : this.exceptionHandler.orElse(exceptionHandler);
        return this;
    }

    @Deprecated
    public GrpcServiceBuilder exceptionMapping(GrpcStatusFunction statusFunction) {
        Objects.requireNonNull(statusFunction, "statusFunction");
        return this.exceptionHandler((ctx, status, throwable, metadata) -> statusFunction.apply(ctx, throwable, metadata));
    }

    @Deprecated
    public GrpcServiceBuilder addExceptionMapping(Class<? extends Throwable> exceptionType, Status status) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(status, "status");
        Preconditions.checkState((this.exceptionHandler == null ? 1 : 0) != 0, (Object)"addExceptionMapping() and exceptionHandler() are mutually exclusive.");
        this.exceptionMappingsBuilder().on(exceptionType, status);
        return this;
    }

    @Deprecated
    public <T extends Throwable> GrpcServiceBuilder addExceptionMapping(Class<T> exceptionType, BiFunction<T, Metadata, Status> statusFunction) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(statusFunction, "statusFunction");
        Preconditions.checkState((this.exceptionHandler == null ? 1 : 0) != 0, (Object)"addExceptionMapping() and exceptionMapping() are mutually exclusive.");
        this.exceptionMappingsBuilder().on(exceptionType, statusFunction);
        return this;
    }

    @Deprecated
    public GrpcServiceBuilder addExceptionMapping(Class<? extends Throwable> exceptionType, GrpcStatusFunction statusFunction) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(statusFunction, "statusFunction");
        Preconditions.checkState((this.exceptionHandler == null ? 1 : 0) != 0, (Object)"addExceptionMapping() and exceptionMapping() are mutually exclusive.");
        this.exceptionMappingsBuilder().on(exceptionType, (ctx, status, throwable, metadata) -> statusFunction.apply(ctx, throwable, metadata));
        return this;
    }

    private GrpcExceptionHandlerFunctionBuilder exceptionMappingsBuilder() {
        if (this.exceptionMappingsBuilder == null) {
            this.exceptionMappingsBuilder = GrpcExceptionHandlerFunction.builder();
        }
        return this.exceptionMappingsBuilder;
    }

    private ImmutableList.Builder<ServerInterceptor> interceptors() {
        if (this.interceptors == null) {
            this.interceptors = ImmutableList.builder();
        }
        return this.interceptors;
    }

    public GrpcService build() {
        HandlerRegistry handlerRegistry;
        if (USE_COROUTINE_CONTEXT_INTERCEPTOR) {
            ArmeriaCoroutineContextInterceptor coroutineContextInterceptor = new ArmeriaCoroutineContextInterceptor(this.useBlockingTaskExecutor);
            this.interceptors().add((Object)coroutineContextInterceptor);
        }
        if (!this.enableUnframedRequests && this.unframedGrpcErrorHandler != null) {
            throw new IllegalStateException("'unframedGrpcErrorHandler' can only be set if unframed requests are enabled");
        }
        if (!this.enableHttpJsonTranscoding && this.httpJsonTranscodingErrorHandler != null) {
            throw new IllegalStateException("'httpJsonTranscodingErrorHandler' can only be set if HTTP/JSON transcoding feature is enabled");
        }
        if (this.enableHttpJsonTranscoding && !this.supportedSerializationFormats.contains(GrpcSerializationFormats.JSON)) {
            throw new IllegalStateException("'GrpcSerializationFormats.JSON' must be set if 'enableHttpJsonTranscoding' is set");
        }
        if (this.enableHealthCheckService) {
            this.grpcHealthCheckService = GrpcHealthCheckService.builder().build();
        }
        if (this.grpcHealthCheckService != null) {
            this.registryBuilder.addService(this.grpcHealthCheckService.bindService(), null, (List<? extends Function<? super HttpService, ? extends HttpService>>)ImmutableList.of());
        }
        GrpcExceptionHandlerFunction grpcExceptionHandler = this.exceptionMappingsBuilder != null ? this.exceptionMappingsBuilder.build().orElse(GrpcExceptionHandlerFunction.of()) : (this.exceptionHandler != null ? this.exceptionHandler.orElse(GrpcExceptionHandlerFunction.of()) : GrpcExceptionHandlerFunction.of());
        this.registryBuilder.setDefaultExceptionHandler(grpcExceptionHandler);
        if (this.interceptors != null) {
            HandlerRegistry.Builder newRegistryBuilder = new HandlerRegistry.Builder();
            ImmutableList interceptors = this.interceptors.build();
            for (HandlerRegistry.Entry entry : this.registryBuilder.entries()) {
                MethodDescriptor<?, ?> methodDescriptor = entry.method();
                ServerServiceDefinition intercepted = ServerInterceptors.intercept((ServerServiceDefinition)entry.service(), (List)interceptors);
                newRegistryBuilder.addService(entry.path(), intercepted, methodDescriptor, entry.type(), entry.additionalDecorators());
            }
            if (grpcExceptionHandler != null) {
                newRegistryBuilder.setDefaultExceptionHandler(grpcExceptionHandler);
            }
            handlerRegistry = newRegistryBuilder.build();
        } else {
            handlerRegistry = this.registryBuilder.build();
        }
        GrpcService grpcService = new FramedGrpcService(handlerRegistry, (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), this.supportedSerializationFormats, this.jsonMarshallerFactory, this.protoReflectionServiceInterceptor, this.maxRequestMessageLength, this.maxResponseMessageLength, this.useBlockingTaskExecutor, this.unsafeWrapRequestBuffers, this.useClientTimeoutHeader, this.enableHttpJsonTranscoding, this.grpcHealthCheckService, this.autoCompression, this.useMethodMarshaller);
        if (this.enableUnframedRequests) {
            grpcService = new UnframedGrpcService(grpcService, handlerRegistry, this.unframedGrpcErrorHandler != null ? this.unframedGrpcErrorHandler : UnframedGrpcErrorHandler.of());
        }
        if (this.enableHttpJsonTranscoding) {
            HttpJsonTranscodingOptions httpJsonTranscodingOptions = this.httpJsonTranscodingErrorHandler != null ? HttpJsonTranscodingOptions.builder().queryParamMatchRules(this.httpJsonTranscodingOptions.queryParamMatchRules()).errorHandler(this.httpJsonTranscodingErrorHandler).build() : this.httpJsonTranscodingOptions;
            grpcService = HttpJsonTranscodingService.of(grpcService, httpJsonTranscodingOptions);
        }
        if (handlerRegistry.containsDecorators()) {
            grpcService = new GrpcDecoratingService(grpcService, handlerRegistry);
        }
        return grpcService;
    }

    static {
        boolean useCoroutineContextInterceptor;
        DEFAULT_SUPPORTED_SERIALIZATION_FORMATS = GrpcSerializationFormats.values();
        logger = LoggerFactory.getLogger(GrpcServiceBuilder.class);
        String className = BindableService.class.getPackage().getName() + ".kotlin.CoroutineContextServerInterceptor";
        try {
            Class.forName(className, false, GrpcServiceBuilder.class.getClassLoader());
            useCoroutineContextInterceptor = true;
        }
        catch (Throwable ignored) {
            useCoroutineContextInterceptor = false;
        }
        logger.debug("{}: {}", (Object)className, (Object)(useCoroutineContextInterceptor ? "available" : "unavailable"));
        USE_COROUTINE_CONTEXT_INTERCEPTOR = useCoroutineContextInterceptor;
    }
}

