/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.endpoint.healthcheck;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.InvalidResponseException;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckerContext;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.common.Attributes;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.AsyncCloseable;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.internal.client.endpoint.EndpointAttributeKeys;
import com.linecorp.armeria.internal.common.util.ReentrantShortLock;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

final class DefaultHealthCheckerContext
extends AbstractExecutorService
implements HealthCheckerContext,
ScheduledExecutorService {
    private final Endpoint originalEndpoint;
    private final Endpoint endpoint;
    private final SessionProtocol protocol;
    private final ClientOptions clientOptions;
    private final ReentrantLock lock = new ReentrantShortLock();
    @GuardedBy(value="lock")
    private final Map<Future<?>, Boolean> scheduledFutures = new IdentityHashMap();
    private final CompletableFuture<Void> initialCheckFuture = new EventLoopCheckingFuture<Void>();
    private final Backoff retryBackoff;
    private final BiConsumer<Endpoint, Boolean> onUpdateHealth;
    @Nullable
    private AsyncCloseable handle;
    private boolean destroyed;
    private int refCnt = 1;
    private Attributes endpointAttributes;

    DefaultHealthCheckerContext(Endpoint endpoint, int port, SessionProtocol protocol, ClientOptions clientOptions, Backoff retryBackoff, BiConsumer<Endpoint, Boolean> onUpdateHealth) {
        this.originalEndpoint = endpoint;
        this.endpoint = port == 0 ? endpoint.withoutDefaultPort(protocol) : (port == protocol.defaultPort() ? endpoint.withoutPort() : endpoint.withPort(port));
        this.protocol = protocol;
        this.clientOptions = clientOptions;
        this.retryBackoff = retryBackoff;
        this.onUpdateHealth = onUpdateHealth;
        this.endpointAttributes = EndpointAttributeKeys.healthCheckAttributes(false, false);
    }

    void init(AsyncCloseable handle) {
        assert (this.handle == null);
        this.handle = handle;
    }

    boolean initializationStarted() {
        return this.handle != null;
    }

    CompletableFuture<Void> whenInitialized() {
        return this.initialCheckFuture;
    }

    private CompletableFuture<Void> destroy() {
        assert (this.handle != null) : this.handle;
        return this.handle.closeAsync().handle((unused1, unused2) -> {
            this.lock.lock();
            try {
                if (this.destroyed) {
                    Void void_ = null;
                    return void_;
                }
                this.destroyed = true;
                if (!this.scheduledFutures.isEmpty()) {
                    ImmutableList<Future<?>> copy = ImmutableList.copyOf(this.scheduledFutures.keySet());
                    copy.forEach((Consumer<Future<?>>)((Consumer<Future>)f -> f.cancel(false)));
                }
            }
            finally {
                this.lock.unlock();
            }
            this.endpointAttributes = EndpointAttributeKeys.healthCheckAttributes(false, false);
            this.onUpdateHealth.accept(this.originalEndpoint.withAttrs(this.endpointAttributes), false);
            return null;
        });
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    public Endpoint originalEndpoint() {
        return this.originalEndpoint;
    }

    Attributes endpointAttributes() {
        return this.endpointAttributes;
    }

    @Override
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public ClientOptions clientOptions() {
        return this.clientOptions;
    }

    @Override
    public ScheduledExecutorService executor() {
        return this;
    }

    @Override
    public long nextDelayMillis() {
        long delayMillis = this.retryBackoff.nextDelayMillis(1);
        if (delayMillis < 0L) {
            throw new IllegalStateException("retryBackoff.nextDelayMillis(1) returned a negative value for " + this.endpoint + ": " + delayMillis);
        }
        return delayMillis;
    }

    @Override
    public void updateHealth(double health) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateHealth(double health, @Nullable ClientRequestContext ctx, @Nullable ResponseHeaders headers, @Nullable Throwable cause) {
        boolean isHealthy = health > 0.0;
        this.endpointAttributes = headers != null && headers.contains("x-envoy-degraded") ? EndpointAttributeKeys.healthCheckAttributes(isHealthy, true) : EndpointAttributeKeys.healthCheckAttributes(isHealthy, false);
        this.onUpdateHealth.accept(this.originalEndpoint.withAttrs(this.endpointAttributes), isHealthy);
        if (!this.initialCheckFuture.isDone()) {
            if (isHealthy) {
                this.initialCheckFuture.complete(null);
            } else if (cause != null) {
                this.initialCheckFuture.completeExceptionally(cause);
            } else {
                assert (headers != null);
                this.initialCheckFuture.completeExceptionally(new InvalidResponseException(ctx + " Received an unhealthy check response. headers: " + headers));
            }
        }
    }

    @Override
    public void execute(Runnable command) {
        this.lock.lock();
        try {
            this.rejectIfDestroyed(command);
            this.add(this.eventLoopGroup().submit(command));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.lock.lock();
        try {
            this.rejectIfDestroyed(command);
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.add(this.eventLoopGroup().schedule(command, delay, unit));
            return scheduledFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.lock.lock();
        try {
            this.rejectIfDestroyed(callable);
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.add(this.eventLoopGroup().schedule(callable, delay, unit));
            return scheduledFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.lock.lock();
        try {
            this.rejectIfDestroyed(command);
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.add(this.eventLoopGroup().scheduleAtFixedRate(command, initialDelay, period, unit));
            return scheduledFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.lock.lock();
        try {
            this.rejectIfDestroyed(command);
            ScheduledFuture scheduledFuture = (ScheduledFuture)this.add(this.eventLoopGroup().scheduleWithFixedDelay(command, initialDelay, delay, unit));
            return scheduledFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return this.eventLoopGroup().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.eventLoopGroup().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.eventLoopGroup().awaitTermination(timeout, unit);
    }

    private EventLoopGroup eventLoopGroup() {
        return this.clientOptions.factory().eventLoopGroup();
    }

    private void rejectIfDestroyed(Object command) {
        if (this.destroyed) {
            throw new RejectedExecutionException(HealthCheckerContext.class.getSimpleName() + " for '" + this.endpoint + "' has been destroyed already. Task: " + command);
        }
    }

    private <T extends Future<U>, U> T add(T future) {
        this.scheduledFutures.put(future, Boolean.TRUE);
        future.addListener(f -> {
            this.lock.lock();
            try {
                this.scheduledFutures.remove(f);
            }
            finally {
                this.lock.unlock();
            }
        });
        return future;
    }

    int refCnt() {
        return this.refCnt;
    }

    DefaultHealthCheckerContext retain() {
        if (this.destroyed) {
            throw new IllegalStateException("HealthCheckerContext is closed already");
        }
        ++this.refCnt;
        return this;
    }

    @Nullable
    CompletableFuture<?> release() {
        assert (this.refCnt > 0) : this.refCnt;
        if (--this.refCnt == 0) {
            return this.destroy();
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("originalEndpoint", this.originalEndpoint).add("endpoint", this.endpoint).add("initializationStarted", this.initializationStarted()).add("initialized", this.initialCheckFuture.isDone()).add("destroyed", this.destroyed).add("refCnt", this.refCnt).toString();
    }
}

