/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.endpoint;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import java.util.List;

public final class EndpointToStringUtil {
    public static String toShortString(List<Endpoint> endpoints) {
        try (TemporaryThreadLocals acquired = TemporaryThreadLocals.acquire();){
            StringBuilder builder = acquired.stringBuilder();
            builder.append('[');
            for (int i = 0; i < endpoints.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                Endpoint endpoint = endpoints.get(i);
                EndpointToStringUtil.toShortString(builder, endpoint);
            }
            builder.append(']');
            String string = builder.toString();
            return string;
        }
    }

    public static String toShortString(Endpoint endpoint) {
        try (TemporaryThreadLocals acquired = TemporaryThreadLocals.acquire();){
            StringBuilder builder = acquired.stringBuilder();
            EndpointToStringUtil.toShortString(builder, endpoint);
            String string = builder.toString();
            return string;
        }
    }

    private static void toShortString(StringBuilder builder, Endpoint endpoint) {
        builder.append(endpoint.host());
        if (endpoint.hasIpAddr() && !endpoint.isIpAddrOnly()) {
            builder.append('/').append(endpoint.ipAddr());
        }
        if (endpoint.hasPort()) {
            builder.append(':').append(endpoint.port());
        }
        builder.append(" (weight: ").append(endpoint.weight()).append(')');
    }

    private EndpointToStringUtil() {
    }
}

