/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.UnloggedExceptionsReporter;

final class ExceptionReportingServiceErrorHandler
implements ServiceErrorHandler {
    private final ServiceErrorHandler delegate;
    private final UnloggedExceptionsReporter reporter;

    ExceptionReportingServiceErrorHandler(ServiceErrorHandler delegate, UnloggedExceptionsReporter reporter) {
        this.delegate = delegate;
        this.reporter = reporter;
    }

    @Override
    @Nullable
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        HttpResponse httpResponse = this.delegate.onServiceException(ctx, cause);
        if (ctx.shouldReportUnloggedExceptions() && !ExceptionReportingServiceErrorHandler.isIgnorableException(cause)) {
            this.reporter.report(cause);
        }
        return httpResponse;
    }

    private static boolean isIgnorableException(Throwable cause) {
        if (Exceptions.isExpected(cause)) {
            return true;
        }
        return (cause instanceof HttpStatusException || cause instanceof HttpResponseException) && cause.getCause() == null;
    }

    @Override
    @Nullable
    public AggregatedHttpResponse renderStatus(ServiceRequestContext ctx, RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        return this.delegate.renderStatus(ctx, headers, status, description, cause);
    }
}

