/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.v6.codec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.InputStream;
import org.apache.skywalking.library.elasticsearch.requests.IndexRequest;
import org.apache.skywalking.library.elasticsearch.requests.UpdateRequest;
import org.apache.skywalking.library.elasticsearch.requests.factory.Codec;
import org.apache.skywalking.library.elasticsearch.requests.factory.v6.codec.V6IndexRequestSerializer;
import org.apache.skywalking.library.elasticsearch.requests.factory.v6.codec.V6IndexTemplatesDeserializer;
import org.apache.skywalking.library.elasticsearch.requests.factory.v6.codec.V6MappingsDeserializer;
import org.apache.skywalking.library.elasticsearch.requests.factory.v6.codec.V6MappingsSerializer;
import org.apache.skywalking.library.elasticsearch.requests.factory.v6.codec.V6UpdateRequestSerializer;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplates;
import org.apache.skywalking.library.elasticsearch.response.Mappings;

public final class V6Codec
implements Codec {
    public static final Codec INSTANCE = new V6Codec();
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new SimpleModule().addSerializer(IndexRequest.class, (JsonSerializer)new V6IndexRequestSerializer()).addSerializer(UpdateRequest.class, (JsonSerializer)new V6UpdateRequestSerializer()).addSerializer(Mappings.class, (JsonSerializer)new V6MappingsSerializer()).addDeserializer(Mappings.class, (JsonDeserializer)new V6MappingsDeserializer()).addDeserializer(IndexTemplates.class, (JsonDeserializer)new V6IndexTemplatesDeserializer())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Override
    public byte[] encode(Object request) throws Exception {
        return MAPPER.writeValueAsBytes(request);
    }

    @Override
    public <T> T decode(InputStream inputStream, TypeReference<T> type) throws Exception {
        return (T)MAPPER.readValue(inputStream, type);
    }

    @Override
    public <T> T decode(InputStream inputStream, Class<T> clazz) throws Exception {
        return (T)MAPPER.readValue(inputStream, clazz);
    }
}

