/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.response.Index;
import org.apache.skywalking.library.elasticsearch.response.IndexTemplate;
import org.apache.skywalking.library.elasticsearch.response.Mappings;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.model.ElasticSearchExtension;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.core.storage.model.ModelInstaller;
import org.apache.skywalking.oap.server.library.client.Client;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.AnalyzerSetting;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ColumnTypeEsMapping;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexStructures;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.MatchCNameBuilder;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEsInstaller
extends ModelInstaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageEsInstaller.class);
    private final Gson gson = new Gson();
    private final StorageModuleElasticsearchConfig config;
    protected final ColumnTypeEsMapping columnTypeEsMapping = new ColumnTypeEsMapping();
    private final Map<String, Map<String, Object>> specificIndexesSettings;
    private int indexRefreshInterval = 30;
    private final IndexStructures structures;

    public StorageEsInstaller(Client client, ModuleManager moduleManager, StorageModuleElasticsearchConfig config) {
        super(client, moduleManager);
        this.config = config;
        this.structures = this.getStructures();
        this.specificIndexesSettings = StringUtil.isNotEmpty((String)config.getSpecificIndexSettings()) ? (Map)this.gson.fromJson(config.getSpecificIndexSettings(), new TypeReference<Map<String, Map<String, Object>>>(){}.getType()) : Collections.emptyMap();
    }

    protected IndexStructures getStructures() {
        return new IndexStructures();
    }

    public ModelInstaller.InstallInfo isExists(Model model) throws StorageException {
        InstallInfoES installInfo = new InstallInfoES(model, this.config);
        ElasticSearchClient esClient = (ElasticSearchClient)this.client;
        String tableName = IndexController.INSTANCE.getTableName(model);
        IndexController.LogicIndicesRegister.registerRelation(model, tableName);
        installInfo.setTableName(esClient.formatIndexName(tableName));
        if (!model.isTimeSeries()) {
            boolean exist = esClient.isExistsIndex(tableName);
            installInfo.setTableExist(exist);
            if (exist) {
                Optional index = esClient.getIndex(tableName);
                Mappings historyMapping = index.map(Index::getMappings).orElseGet(Mappings::new);
                this.structures.putStructure(tableName, historyMapping, index.map(Index::getSettings).orElseGet(HashMap::new));
                if (RunningMode.isNoInitMode()) {
                    exist = this.structures.containsFieldNames(tableName, this.createMapping(model));
                    installInfo.setAllFieldsExist(exist);
                } else {
                    boolean containsMapping = this.structures.containsMapping(tableName, this.createMapping(model));
                    installInfo.setAllFieldsExist(containsMapping);
                    boolean containsSetting = this.structures.compareIndexSetting(tableName, this.createSetting(model));
                    installInfo.setAllIndexSettingsExist(containsSetting);
                    exist = containsMapping && containsSetting;
                }
            }
            installInfo.setAllExist(exist);
            return installInfo;
        }
        boolean templateExists = esClient.isExistsTemplate(tableName);
        installInfo.setTableExist(templateExists);
        Optional template = esClient.getTemplate(tableName);
        if (templateExists && template.isEmpty() || !templateExists && template.isPresent()) {
            throw new Error("[Bug warning] ElasticSearch client query template result is not consistent. Please file an issue to Apache SkyWalking.(https://github.com/apache/skywalking/issues)");
        }
        boolean exist = templateExists;
        if (exist) {
            this.structures.putStructure(tableName, ((IndexTemplate)template.get()).getMappings(), ((IndexTemplate)template.get()).getSettings());
            if (RunningMode.isNoInitMode()) {
                exist = this.structures.containsFieldNames(tableName, this.createMapping(model));
                installInfo.setAllFieldsExist(exist);
            } else {
                boolean containsMapping = this.structures.containsMapping(tableName, this.createMapping(model));
                installInfo.setAllFieldsExist(containsMapping);
                boolean containsSetting = this.structures.compareIndexSetting(tableName, this.createSetting(model));
                installInfo.setAllIndexSettingsExist(containsSetting);
                exist = containsMapping && containsSetting;
            }
        }
        installInfo.setAllExist(exist);
        return installInfo;
    }

    public void createTable(Model model) throws StorageException {
        if (model.isTimeSeries()) {
            this.createTimeSeriesTable(model);
        } else {
            this.createNormalTable(model);
        }
    }

    private void createNormalTable(Model model) throws StorageException {
        ElasticSearchClient esClient = (ElasticSearchClient)this.client;
        String tableName = IndexController.INSTANCE.getTableName(model);
        Mappings mapping = this.createMapping(model);
        Map<String, Object> settings = this.createSetting(model);
        if (!esClient.isExistsIndex(tableName)) {
            boolean isAcknowledged = esClient.createIndex(tableName, mapping, settings);
            log.info("create {} index finished, isAcknowledged: {}", (Object)tableName, (Object)isAcknowledged);
            if (!isAcknowledged) {
                throw new StorageException("create " + tableName + " index failure");
            }
        } else {
            Mappings historyMapping = esClient.getIndex(tableName).map(Index::getMappings).orElseGet(Mappings::new);
            this.structures.putStructure(tableName, mapping, settings);
            Mappings appendMapping = this.structures.diffMappings(tableName, historyMapping);
            if (appendMapping.getProperties() != null && !appendMapping.getProperties().isEmpty()) {
                boolean isAcknowledged = esClient.updateIndexMapping(tableName, appendMapping);
                log.info("update {} index mapping finished, isAcknowledged: {}, append mapping: {}", new Object[]{tableName, isAcknowledged, appendMapping});
                if (!isAcknowledged) {
                    throw new StorageException("update " + tableName + " index mapping failure");
                }
            }
            if (!this.structures.compareIndexSetting(tableName, settings)) {
                log.warn("index {} settings configuration has been updated to {}, please remove it before OAP starts", (Object)tableName, settings);
            }
        }
    }

    private void createTimeSeriesTable(Model model) throws StorageException {
        ElasticSearchClient esClient = (ElasticSearchClient)this.client;
        String tableName = IndexController.INSTANCE.getTableName(model);
        Map<String, Object> settings = this.createSetting(model);
        Mappings mapping = this.createMapping(model);
        String indexName = TimeSeriesUtils.latestWriteIndexName(model);
        try {
            boolean isAcknowledged;
            boolean shouldUpdateTemplate = !esClient.isExistsTemplate(tableName);
            boolean bl = shouldUpdateTemplate = shouldUpdateTemplate || !this.structures.containsMapping(tableName, mapping) || !this.structures.compareIndexSetting(tableName, settings);
            if (shouldUpdateTemplate) {
                this.structures.putStructure(tableName, mapping, settings);
                isAcknowledged = esClient.createOrUpdateTemplate(tableName, settings, this.structures.getMapping(tableName), this.config.getIndexTemplateOrder());
                log.info("create {} index template finished, isAcknowledged: {}", (Object)tableName, (Object)isAcknowledged);
                if (!isAcknowledged) {
                    throw new IOException("create " + tableName + " index template failure");
                }
            }
            if (esClient.isExistsIndex(indexName)) {
                Mappings historyMapping = esClient.getIndex(indexName).map(Index::getMappings).orElseGet(Mappings::new);
                Mappings appendMapping = this.structures.diffMappings(tableName, historyMapping);
                if (appendMapping.getProperties() != null && !appendMapping.getProperties().isEmpty()) {
                    boolean isAcknowledged2 = esClient.updateIndexMapping(indexName, appendMapping);
                    log.info("update {} index finished, isAcknowledged: {}, append mappings: {}", new Object[]{indexName, isAcknowledged2, appendMapping});
                    if (!isAcknowledged2) {
                        throw new StorageException("update " + indexName + " time series index failure");
                    }
                }
                if (!this.structures.compareIndexSetting(tableName, settings)) {
                    log.info("index template {} settings configuration has been updated to {}, it will applied on new index", (Object)tableName, settings);
                }
            } else {
                isAcknowledged = esClient.createIndex(indexName);
                log.info("create {} index finished, isAcknowledged: {}", (Object)indexName, (Object)isAcknowledged);
                if (!isAcknowledged) {
                    throw new StorageException("create " + indexName + " time series index failure");
                }
            }
        }
        catch (IOException e) {
            throw new StorageException("cannot create " + tableName + " index template", (Throwable)e);
        }
    }

    protected Map<String, Object> createSetting(Model model) throws StorageException {
        Map<String, Object> specificSettings;
        HashMap<String, Object> setting = new HashMap<String, Object>();
        HashMap<String, Object> indexSettings = new HashMap<String, Object>();
        setting.put("index", indexSettings);
        indexSettings.put("number_of_replicas", model.isSuperDataset() ? Integer.toString(this.config.getSuperDatasetIndexReplicasNumber()) : Integer.toString(this.config.getIndexReplicasNumber()));
        indexSettings.put("number_of_shards", model.isSuperDataset() ? Integer.toString(this.config.getIndexShardsNumber() * this.config.getSuperDatasetIndexShardsFactor()) : Integer.toString(this.config.getIndexShardsNumber()));
        indexSettings.put("refresh_interval", this.indexRefreshInterval + "s");
        indexSettings.put("analysis", this.getAnalyzerSetting(model));
        if (!StringUtil.isEmpty((String)this.config.getAdvanced())) {
            Map advancedSettings = (Map)this.gson.fromJson(this.config.getAdvanced(), Map.class);
            setting.putAll(advancedSettings);
        }
        if (!CollectionUtils.isEmpty(specificSettings = this.specificIndexesSettings.get(IndexController.INSTANCE.getTableName(model)))) {
            indexSettings.putAll(specificSettings);
        }
        return setting;
    }

    private Map getAnalyzerSetting(Model model) throws StorageException {
        if (!model.isTimeSeries()) {
            return this.getAnalyzerSetting4MergedIndex(model);
        }
        if (this.config.isLogicSharding()) {
            return this.getAnalyzerSettingByColumn(model);
        }
        if (model.isRecord() && model.isSuperDataset()) {
            return this.getAnalyzerSettingByColumn(model);
        }
        return this.getAnalyzerSetting4MergedIndex(model);
    }

    private Map getAnalyzerSettingByColumn(Model model) throws StorageException {
        AnalyzerSetting analyzerSetting = new AnalyzerSetting();
        List<ModelColumn> analyzerTypes = IndexController.LogicIndicesRegister.getPhysicalTableColumns(model);
        for (ModelColumn column : analyzerTypes) {
            if (!column.getElasticSearchExtension().needMatchQuery()) continue;
            AnalyzerSetting setting = AnalyzerSetting.Generator.getGenerator(column.getElasticSearchExtension().getAnalyzer()).getGenerateFunc().generate(this.config);
            analyzerSetting.combine(setting);
        }
        return (Map)this.gson.fromJson(this.gson.toJson((Object)analyzerSetting), Map.class);
    }

    private Map getAnalyzerSetting4MergedIndex(Model model) throws StorageException {
        AnalyzerSetting setting = AnalyzerSetting.Generator.getGenerator(ElasticSearch.MatchQuery.AnalyzerType.OAP_ANALYZER).getGenerateFunc().generate(this.config);
        return (Map)this.gson.fromJson(this.gson.toJson((Object)setting), Map.class);
    }

    protected Mappings createMapping(Model model) {
        HashMap<String, String> column;
        HashMap properties = new HashMap();
        Mappings.Source source = new Mappings.Source();
        for (ModelColumn columnDefine : model.getColumns()) {
            ElasticSearchExtension elasticSearchExtension = columnDefine.getElasticSearchExtension();
            String type = this.columnTypeEsMapping.transform(columnDefine.getType(), columnDefine.getGenericType(), columnDefine.getLength(), columnDefine.isStorageOnly(), elasticSearchExtension);
            String columnName = columnDefine.getColumnName().getName();
            String legacyName = elasticSearchExtension.getLegacyColumnName();
            HashMap<String, Object> columnProperties = new HashMap<String, Object>();
            if (this.config.isLogicSharding() && !Strings.isNullOrEmpty((String)legacyName)) {
                columnName = legacyName;
            }
            if (elasticSearchExtension.needMatchQuery()) {
                String matchCName = MatchCNameBuilder.INSTANCE.build(columnName);
                columnProperties.put("type", type);
                columnProperties.put("copy_to", matchCName);
                HashMap<String, String> matchColumn = new HashMap<String, String>();
                matchColumn.put("type", "text");
                matchColumn.put("analyzer", elasticSearchExtension.getAnalyzer().getName());
                properties.put(matchCName, matchColumn);
            } else {
                columnProperties.put("type", type);
                if (columnDefine.isStorageOnly() && !"binary".equals(type)) {
                    columnProperties.put("index", false);
                }
            }
            if (!"text".equals(type) && !elasticSearchExtension.isDocValuesEnabled()) {
                columnProperties.put("doc_values", false);
            }
            properties.put(columnName, columnProperties);
            if (!columnDefine.isIndexOnly()) continue;
            source.getExcludes().add(columnName);
        }
        if (!model.isTimeSeries()) {
            column = new HashMap<String, String>();
            column.put("type", "keyword");
            properties.put("management_table", column);
        }
        if (model.isMetric() && !this.config.isLogicSharding() || this.config.isLogicSharding() && IndexController.INSTANCE.isFunctionMetric(model)) {
            column = new HashMap();
            column.put("type", "keyword");
            properties.put("metric_table", column);
        }
        if (!this.config.isLogicSharding() && model.isRecord() && !model.isSuperDataset()) {
            column = new HashMap();
            column.put("type", "keyword");
            properties.put("record_table", column);
        }
        Mappings mappings = Mappings.builder().type("type").properties(properties).source(source).build();
        if (log.isDebugEnabled()) {
            log.debug("elasticsearch index template setting: {}", (Object)mappings.toString());
        }
        return mappings;
    }

    @Generated
    public void setIndexRefreshInterval(int indexRefreshInterval) {
        this.indexRefreshInterval = indexRefreshInterval;
    }

    public static class InstallInfoES
    extends ModelInstaller.InstallInfo {
        private String tableName;
        private boolean tableExist;
        private boolean allFieldsExist;
        private boolean allIndexSettingsExist;
        private StorageModuleElasticsearchConfig config;

        protected InstallInfoES(Model model, StorageModuleElasticsearchConfig config) {
            super(model);
            this.config = config;
        }

        public String buildInstallInfoMsg() {
            String tableNameMsg = this.isTimeSeries() ? "indexTemplateName=" + this.tableName : "indexName=" + this.tableName;
            String tableExistMsg = this.isTimeSeries() ? "indexTemplateExists=" + this.tableExist : "indexExists=" + this.tableExist;
            return "InstallInfoES:{modelName=" + this.getModelName() + ", modelType=" + this.getModelType() + ", timeSeries=" + this.isTimeSeries() + ", superDataset=" + this.isSuperDataset() + ", logicSharding=" + this.config.isLogicSharding() + ", indexNamespace=" + this.config.getNamespace() + ", " + tableNameMsg + ", allResourcesExist=" + this.isAllExist() + " [" + tableExistMsg + ", allFieldsExist=" + this.allFieldsExist + ", allIndexSettingsExist=" + this.allIndexSettingsExist + "]}";
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public boolean isTableExist() {
            return this.tableExist;
        }

        @Generated
        public boolean isAllFieldsExist() {
            return this.allFieldsExist;
        }

        @Generated
        public boolean isAllIndexSettingsExist() {
            return this.allIndexSettingsExist;
        }

        @Generated
        public StorageModuleElasticsearchConfig getConfig() {
            return this.config;
        }

        @Generated
        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Generated
        public void setTableExist(boolean tableExist) {
            this.tableExist = tableExist;
        }

        @Generated
        public void setAllFieldsExist(boolean allFieldsExist) {
            this.allFieldsExist = allFieldsExist;
        }

        @Generated
        public void setAllIndexSettingsExist(boolean allIndexSettingsExist) {
            this.allIndexSettingsExist = allIndexSettingsExist;
        }

        @Generated
        public void setConfig(StorageModuleElasticsearchConfig config) {
            this.config = config;
        }
    }
}

