/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.cache;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchScroller;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressAliasEsDAO
extends EsDAO
implements INetworkAddressAliasDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAddressAliasEsDAO.class);
    protected final int resultWindowMaxSize;
    protected final int scrollingBatchSize;

    public NetworkAddressAliasEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.resultWindowMaxSize = config.getResultWindowMaxSize();
        this.scrollingBatchSize = config.getScrollingBatchSize();
    }

    public List<NetworkAddressAlias> loadLastUpdate(long timeBucketInMinute) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("network_address_alias");
        try {
            int batchSize = Math.min(this.resultWindowMaxSize, this.scrollingBatchSize);
            BoolQueryBuilder query = Query.bool();
            if (IndexController.LogicIndicesRegister.isMergedTable("network_address_alias")) {
                query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"network_address_alias"));
            }
            query.must((QueryBuilder)Query.range((String)"last_update_time_bucket").gte((Object)timeBucketInMinute));
            Search search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(batchSize)).build();
            NetworkAddressAlias.Builder builder = new NetworkAddressAlias.Builder();
            ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search).index(index).queryMaxSize(this.resultWindowMaxSize).resultConverter(searchHit -> builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("network_address_alias", searchHit.getSource()))).build();
            return scroller.scroll();
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            return Collections.emptyList();
        }
    }
}

