/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerEventType;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class AsyncProfilerTaskQueryEsDAO
extends EsDAO
implements IAsyncProfilerTaskQueryDAO {
    private static final Gson GSON = new Gson();
    private final int queryMaxSize;

    public AsyncProfilerTaskQueryEsDAO(ElasticSearchClient client, int queryMaxSize) {
        super(client);
        this.queryMaxSize = queryMaxSize;
    }

    public List<AsyncProfilerTask> getTaskList(String serviceId, Long startTimeBucket, Long endTimeBucket, Integer limit) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("async_profiler_task");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("async_profiler_task")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"async_profiler_task"));
        }
        if (StringUtil.isNotEmpty((String)serviceId)) {
            query.must((QueryBuilder)Query.term((String)"service_id", (Object)serviceId));
        }
        if (startTimeBucket != null) {
            query.must((QueryBuilder)Query.range((String)"time_bucket").gte((Object)startTimeBucket));
        }
        if (endTimeBucket != null) {
            query.must((QueryBuilder)Query.range((String)"time_bucket").lte((Object)endTimeBucket));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query);
        search.size(Objects.requireNonNullElse(limit, this.queryMaxSize));
        search.sort("create_time", Sort.Order.DESC);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        LinkedList<AsyncProfilerTask> tasks = new LinkedList<AsyncProfilerTask>();
        for (SearchHit searchHit : response.getHits()) {
            tasks.add(this.parseTask(searchHit));
        }
        return tasks;
    }

    public AsyncProfilerTask getById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        BoolQueryBuilder query = Query.bool();
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("async_profiler_task");
        if (IndexController.LogicIndicesRegister.isMergedTable("async_profiler_task")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"async_profiler_task"));
        }
        query.must((QueryBuilder)Query.term((String)"task_id", (Object)id));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(1));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        if (!response.getHits().getHits().isEmpty()) {
            return this.parseTask((SearchHit)response.getHits().getHits().iterator().next());
        }
        return null;
    }

    private AsyncProfilerTask parseTask(SearchHit data) {
        Map source = data.getSource();
        Type listType = new TypeToken<List<String>>(){}.getType();
        String events = (String)source.get("events");
        List eventList = (List)GSON.fromJson(events, listType);
        String serviceInstanceIds = (String)source.get("service_instance_ids");
        List instanceIdList = (List)GSON.fromJson(serviceInstanceIds, listType);
        return AsyncProfilerTask.builder().id((String)source.get("task_id")).serviceId((String)source.get("service_id")).serviceInstanceIds(instanceIdList).createTime(((Number)source.get("create_time")).longValue()).duration(((Number)source.get("duration")).intValue()).execArgs((String)source.get("exec_args")).events(AsyncProfilerEventType.valueOfList((List)eventList)).build();
    }
}

