/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.library.kubernetes.KubernetesEndpoints;
import org.apache.skywalking.library.kubernetes.KubernetesPods;
import org.apache.skywalking.library.kubernetes.KubernetesServices;
import org.apache.skywalking.library.kubernetes.ObjectID;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.ServiceNameFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8SServiceRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8SServiceRegistry.class);
    protected final EnvoyMetricReceiverConfig config;
    protected final ServiceNameFormatter serviceNameFormatter;
    protected final LoadingCache<K8SServiceRegistry, Set<String>> nodeIPs;
    protected final LoadingCache<String, ServiceMetaInfo> ipServiceMetaInfoMap;

    public K8SServiceRegistry(final EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.serviceNameFormatter = new ServiceNameFormatter(config.getK8sServiceNameRule());
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(3L));
        this.nodeIPs = cacheBuilder.build(CacheLoader.from(() -> {
            Set set;
            block8: {
                KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
                try {
                    set = ((NodeList)kubernetesClient.nodes().list()).getItems().stream().map(Node::getStatus).map(NodeStatus::getAddresses).flatMap(it -> it.stream().map(NodeAddress::getAddress).filter(StringUtil::isNotBlank)).collect(Collectors.toSet());
                    if (kubernetesClient == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (kubernetesClient != null) {
                            try {
                                kubernetesClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.error("Failed to list Nodes.", (Throwable)e);
                        return Collections.emptySet();
                    }
                }
                kubernetesClient.close();
            }
            return set;
        }));
        this.ipServiceMetaInfoMap = cacheBuilder.build((CacheLoader)new CacheLoader<String, ServiceMetaInfo>(){

            public ServiceMetaInfo load(String ip) {
                Optional pod = KubernetesPods.INSTANCE.findByIP(ip);
                if (pod.isEmpty()) {
                    log.debug("No corresponding Pod for IP: {}", (Object)ip);
                    return config.serviceMetaInfoFactory().unknown();
                }
                Optional<ObjectID> serviceID = KubernetesEndpoints.INSTANCE.list().stream().filter(endpoints -> endpoints.getMetadata() != null).filter(endpoints -> endpoints.getSubsets() != null).map(endpoints -> {
                    ObjectMeta metadata = endpoints.getMetadata();
                    if (endpoints.getSubsets().stream().filter(subset -> subset.getAddresses() != null).flatMap(subset -> subset.getAddresses().stream()).anyMatch(address -> Objects.equals(ip, address.getIp()))) {
                        return ObjectID.builder().name(metadata.getName()).namespace(metadata.getNamespace()).build();
                    }
                    return null;
                }).filter(Objects::nonNull).findFirst();
                if (serviceID.isEmpty()) {
                    log.debug("No corresponding endpoint for IP: {}", (Object)ip);
                    return config.serviceMetaInfoFactory().unknown();
                }
                Optional service = KubernetesServices.INSTANCE.findByID(serviceID.get());
                if (service.isEmpty()) {
                    log.debug("No service for namespace and name: {}", (Object)serviceID.get());
                    return config.serviceMetaInfoFactory().unknown();
                }
                log.debug("Composing service meta info from service and pod for IP: {}", (Object)ip);
                return K8SServiceRegistry.this.composeServiceMetaInfo((Service)service.get(), (Pod)pod.get());
            }
        });
    }

    protected List<ServiceMetaInfo.KeyValue> transformLabelsToTags(ObjectMeta podMeta) {
        Map labels = podMeta.getLabels();
        ArrayList<ServiceMetaInfo.KeyValue> tags = new ArrayList<ServiceMetaInfo.KeyValue>();
        tags.add(new ServiceMetaInfo.KeyValue("pod", podMeta.getName()));
        tags.add(new ServiceMetaInfo.KeyValue("namespace", podMeta.getNamespace()));
        if (Objects.isNull(labels)) {
            return tags;
        }
        return labels.entrySet().stream().map(each -> new ServiceMetaInfo.KeyValue((String)each.getKey(), (String)each.getValue())).collect(Collectors.toCollection(() -> tags));
    }

    public ServiceMetaInfo findService(String ip) {
        if (this.isNode(ip)) {
            return this.config.serviceMetaInfoFactory().unknown();
        }
        return (ServiceMetaInfo)this.ipServiceMetaInfoMap.get((Object)ip);
    }

    protected ServiceMetaInfo composeServiceMetaInfo(Service service, Pod pod) {
        ImmutableMap context = ImmutableMap.of((Object)"service", (Object)service, (Object)"pod", (Object)pod);
        ServiceMetaInfo serviceMetaInfo = new ServiceMetaInfo();
        ObjectMeta podMetadata = pod.getMetadata();
        try {
            serviceMetaInfo.setServiceName(this.serviceNameFormatter.format((Map<String, Object>)context));
        }
        catch (Exception e) {
            log.error("Failed to evaluate service name.", (Throwable)e);
            ObjectMeta serviceMetadata = service.getMetadata();
            if (Objects.isNull(serviceMetadata)) {
                log.warn("Service metadata is null, {}", (Object)service);
                return this.config.serviceMetaInfoFactory().unknown();
            }
            serviceMetaInfo.setServiceName(serviceMetadata.getName());
        }
        serviceMetaInfo.setServiceInstanceName(String.format("%s.%s", podMetadata.getName(), podMetadata.getNamespace()));
        serviceMetaInfo.setTags(this.transformLabelsToTags(podMetadata));
        return serviceMetaInfo;
    }

    public boolean isNode(String ip) {
        return ((Set)this.nodeIPs.get((Object)this)).contains(ip);
    }
}

