/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.logql;

import com.linecorp.armeria.common.HttpMethod;
import java.util.Arrays;
import org.apache.skywalking.oap.query.logql.LogQLConfig;
import org.apache.skywalking.oap.query.logql.LogQLModule;
import org.apache.skywalking.oap.query.logql.handler.LogQLApiHandler;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.http.HTTPServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;

public class LogQLProvider
extends ModuleProvider {
    public static final String NAME = "default";
    private LogQLConfig config;
    private HTTPServer httpServer;

    public String name() {
        return NAME;
    }

    public Class<? extends ModuleDefine> module() {
        return LogQLModule.class;
    }

    public ModuleProvider.ConfigCreator<LogQLConfig> newConfigCreator() {
        return new ModuleProvider.ConfigCreator<LogQLConfig>(){

            public Class<LogQLConfig> type() {
                return LogQLConfig.class;
            }

            public void onInitialized(LogQLConfig initialized) {
                LogQLProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException {
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        HTTPServerConfig httpServerConfig = HTTPServerConfig.builder().host(this.config.getRestHost()).port(this.config.getRestPort()).contextPath(this.config.getRestContextPath()).idleTimeOut(this.config.getRestIdleTimeOut()).maxThreads(this.config.getRestMaxThreads()).acceptQueueSize(this.config.getRestAcceptQueueSize()).build();
        this.httpServer = new HTTPServer(httpServerConfig);
        this.httpServer.initialize();
        this.httpServer.addHandler((Object)new LogQLApiHandler(this.getManager()), Arrays.asList(HttpMethod.POST, HttpMethod.GET));
    }

    public void notifyAfterCompleted() {
        if (!RunningMode.isInitMode()) {
            this.httpServer.start();
        }
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

