/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="TaggedAddresses", generator="Immutables")
@Immutable
public final class ImmutableTaggedAddresses
extends TaggedAddresses {
    private final String wan;
    @Nullable
    private final String lan;

    private ImmutableTaggedAddresses(String wan, @Nullable String lan) {
        this.wan = wan;
        this.lan = lan;
    }

    @Override
    @JsonProperty(value="wan")
    public String getWan() {
        return this.wan;
    }

    @Override
    @JsonProperty(value="lan")
    public Optional<String> getLan() {
        return Optional.ofNullable(this.lan);
    }

    public final ImmutableTaggedAddresses withWan(String value) {
        String newValue = Objects.requireNonNull(value, "wan");
        if (this.wan.equals(newValue)) {
            return this;
        }
        return new ImmutableTaggedAddresses(newValue, this.lan);
    }

    public final ImmutableTaggedAddresses withLan(String value) {
        String newValue = Objects.requireNonNull(value, "lan");
        if (Objects.equals(this.lan, newValue)) {
            return this;
        }
        return new ImmutableTaggedAddresses(this.wan, newValue);
    }

    public final ImmutableTaggedAddresses withLan(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lan, value)) {
            return this;
        }
        return new ImmutableTaggedAddresses(this.wan, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaggedAddresses && this.equalTo((ImmutableTaggedAddresses)another);
    }

    private boolean equalTo(ImmutableTaggedAddresses another) {
        return this.wan.equals(another.wan) && Objects.equals(this.lan, another.lan);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.wan.hashCode();
        h += (h << 5) + Objects.hashCode(this.lan);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaggedAddresses").omitNullValues().add("wan", (Object)this.wan).add("lan", (Object)this.lan).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaggedAddresses fromJson(Json json) {
        Builder builder = ImmutableTaggedAddresses.builder();
        if (json.wan != null) {
            builder.wan(json.wan);
        }
        if (json.lan != null) {
            builder.lan(json.lan);
        }
        return builder.build();
    }

    public static ImmutableTaggedAddresses copyOf(TaggedAddresses instance) {
        if (instance instanceof ImmutableTaggedAddresses) {
            return (ImmutableTaggedAddresses)instance;
        }
        return ImmutableTaggedAddresses.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TaggedAddresses", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WAN = 1L;
        private long initBits = 1L;
        @Nullable
        private String wan;
        @Nullable
        private String lan;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TaggedAddresses instance) {
            Objects.requireNonNull(instance, "instance");
            this.wan(instance.getWan());
            Optional<String> lanOptional = instance.getLan();
            if (lanOptional.isPresent()) {
                this.lan(lanOptional);
            }
            return this;
        }

        @JsonProperty(value="wan")
        @CanIgnoreReturnValue
        public final Builder wan(String wan) {
            this.wan = Objects.requireNonNull(wan, "wan");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lan(String lan) {
            this.lan = Objects.requireNonNull(lan, "lan");
            return this;
        }

        @JsonProperty(value="lan")
        @CanIgnoreReturnValue
        public final Builder lan(Optional<String> lan) {
            this.lan = lan.orElse(null);
            return this;
        }

        public ImmutableTaggedAddresses build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaggedAddresses(this.wan, this.lan);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("wan");
            }
            return "Cannot build TaggedAddresses, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TaggedAddresses", generator="Immutables")
    static final class Json
    extends TaggedAddresses {
        @Nullable
        String wan;
        @Nullable
        Optional<String> lan = Optional.empty();

        Json() {
        }

        @JsonProperty(value="wan")
        public void setWan(String wan) {
            this.wan = wan;
        }

        @JsonProperty(value="lan")
        public void setLan(Optional<String> lan) {
            this.lan = lan;
        }

        @Override
        public String getWan() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLan() {
            throw new UnsupportedOperationException();
        }
    }
}

