/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.testing.module.mock;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleNotFoundRuntimeException;
import org.apache.skywalking.oap.server.library.module.ModuleProviderHolder;

public abstract class MockModuleManager
extends ModuleManager {
    private final Map<String, ModuleProviderHolder> moduleProviderHolderMap = Maps.newHashMap();

    public MockModuleManager(String description) {
        super(description);
        this.init();
    }

    protected abstract void init();

    protected void register(String name, ModuleProviderHolder provider) {
        this.moduleProviderHolderMap.put(name, provider);
    }

    public boolean has(String moduleName) {
        return this.moduleProviderHolderMap.containsKey(moduleName);
    }

    public ModuleProviderHolder find(String moduleName) throws ModuleNotFoundRuntimeException {
        if (!this.moduleProviderHolderMap.containsKey(moduleName)) {
            throw new ModuleNotFoundRuntimeException("ModuleProviderHolder[" + moduleName + "] cannot found in MOCK.");
        }
        return this.moduleProviderHolderMap.get(moduleName);
    }
}

