/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.generator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.skywalking.generator.Generator;

@JsonDeserialize(builder=Builder.class)
public final class SequenceGenerator
implements Generator<Object, Long> {
    private final boolean limitedDomain;
    private final long min;
    private final long max;
    private final long step;
    private final Integer fluctuation;
    private final Integer domainSize;
    private final Random random = ThreadLocalRandom.current();
    private final Set<Long> domain = new HashSet<Long>();
    private volatile Long last;

    public SequenceGenerator(Builder builder) {
        this.min = builder.min;
        this.max = builder.max;
        this.step = builder.step;
        this.fluctuation = builder.fluctuation;
        this.domainSize = builder.domainSize;
        this.limitedDomain = builder.domainSize != null && builder.domainSize > 0;
        this.reset();
    }

    @Override
    public Long next(Object ignored) {
        if (!this.limitedDomain) {
            return this.next0();
        }
        return (Long)this.domain.stream().skip(this.random.nextInt(this.domain.size())).findFirst().orElseThrow(() -> new RuntimeException("Should never happen"));
    }

    private synchronized long next0() {
        long next;
        long l = next = this.last == null ? this.min : this.last + this.step;
        if (this.fluctuation != null) {
            int j = this.random.nextInt(this.fluctuation);
            next += this.random.nextBoolean() ? (long)j : (long)(-j);
        }
        if (next > this.max) {
            return this.max;
        }
        if (next < this.min) {
            return this.min;
        }
        this.last = next;
        return this.last;
    }

    @Override
    public void reset() {
        this.last = null;
        if (this.limitedDomain) {
            this.domain.clear();
            while (this.domain.size() < this.domainSize) {
                this.domain.add(this.next0());
            }
        }
    }

    public String toString() {
        return String.valueOf(this.next((Object)null));
    }

    public static class Builder {
        private long min = Long.MIN_VALUE;
        private long max = Long.MAX_VALUE;
        private long step = 1L;
        private Integer domainSize;
        private Integer fluctuation;

        public SequenceGenerator build() {
            if (this.domainSize != null) {
                Preconditions.checkArgument((this.domainSize > 0 ? 1 : 0) != 0, (Object)"domainSize must be > 0");
                Preconditions.checkArgument(((long)this.domainSize.intValue() + this.min <= this.max ? 1 : 0) != 0, (Object)"domain size must be <= max - min");
            }
            return new SequenceGenerator(this);
        }

        @Generated
        public Builder() {
        }

        @Generated
        public long getMin() {
            return this.min;
        }

        @Generated
        public long getMax() {
            return this.max;
        }

        @Generated
        public long getStep() {
            return this.step;
        }

        @Generated
        public Integer getDomainSize() {
            return this.domainSize;
        }

        @Generated
        public Integer getFluctuation() {
            return this.fluctuation;
        }

        @Generated
        public Builder setMin(long min) {
            this.min = min;
            return this;
        }

        @Generated
        public Builder setMax(long max) {
            this.max = max;
            return this;
        }

        @Generated
        public Builder setStep(long step) {
            this.step = step;
            return this;
        }

        @Generated
        public Builder setDomainSize(Integer domainSize) {
            this.domainSize = domainSize;
            return this;
        }

        @Generated
        public Builder setFluctuation(Integer fluctuation) {
            this.fluctuation = fluctuation;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMin() != other.getMin()) {
                return false;
            }
            if (this.getMax() != other.getMax()) {
                return false;
            }
            if (this.getStep() != other.getStep()) {
                return false;
            }
            Integer this$domainSize = this.getDomainSize();
            Integer other$domainSize = other.getDomainSize();
            if (this$domainSize == null ? other$domainSize != null : !((Object)this$domainSize).equals(other$domainSize)) {
                return false;
            }
            Integer this$fluctuation = this.getFluctuation();
            Integer other$fluctuation = other.getFluctuation();
            return !(this$fluctuation == null ? other$fluctuation != null : !((Object)this$fluctuation).equals(other$fluctuation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $min = this.getMin();
            result = result * 59 + (int)($min >>> 32 ^ $min);
            long $max = this.getMax();
            result = result * 59 + (int)($max >>> 32 ^ $max);
            long $step = this.getStep();
            result = result * 59 + (int)($step >>> 32 ^ $step);
            Integer $domainSize = this.getDomainSize();
            result = result * 59 + ($domainSize == null ? 43 : ((Object)$domainSize).hashCode());
            Integer $fluctuation = this.getFluctuation();
            result = result * 59 + ($fluctuation == null ? 43 : ((Object)$fluctuation).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SequenceGenerator.Builder(min=" + this.getMin() + ", max=" + this.getMax() + ", step=" + this.getStep() + ", domainSize=" + this.getDomainSize() + ", fluctuation=" + this.getFluctuation() + ")";
        }
    }
}

