/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.generator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.skywalking.generator.Generator;

@JsonDeserialize(builder=Builder.class)
public class TimeGenerator
implements Generator<Object, Long> {
    private final Long stepMillisecond;
    private final Long waitMillisecond;
    private AtomicLong last;
    private AtomicLong lastSync;

    public TimeGenerator(Builder builder) {
        this.waitMillisecond = builder.waitMillisecond;
        this.stepMillisecond = builder.stepMillisecond;
        this.reset();
    }

    @Override
    public Long next(Object ignored) {
        long current = System.currentTimeMillis();
        if (current - this.lastSync.longValue() < this.waitMillisecond) {
            return this.last.incrementAndGet();
        }
        this.lastSync.set(current);
        return this.last.addAndGet(this.stepMillisecond);
    }

    @Override
    public void reset() {
        this.last = new AtomicLong(System.currentTimeMillis());
        this.lastSync = new AtomicLong(this.last.longValue());
    }

    public static class Builder {
        private Long stepMillisecond;
        private Long waitMillisecond;

        public TimeGenerator build() {
            if (this.stepMillisecond == null) {
                this.stepMillisecond = 1000L;
            }
            if (this.waitMillisecond == null) {
                this.waitMillisecond = 0L;
            }
            return new TimeGenerator(this);
        }

        @Generated
        public Builder() {
        }

        @Generated
        public Long getStepMillisecond() {
            return this.stepMillisecond;
        }

        @Generated
        public Long getWaitMillisecond() {
            return this.waitMillisecond;
        }

        @Generated
        public void setStepMillisecond(Long stepMillisecond) {
            this.stepMillisecond = stepMillisecond;
        }

        @Generated
        public void setWaitMillisecond(Long waitMillisecond) {
            this.waitMillisecond = waitMillisecond;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$stepMillisecond = this.getStepMillisecond();
            Long other$stepMillisecond = other.getStepMillisecond();
            if (this$stepMillisecond == null ? other$stepMillisecond != null : !((Object)this$stepMillisecond).equals(other$stepMillisecond)) {
                return false;
            }
            Long this$waitMillisecond = this.getWaitMillisecond();
            Long other$waitMillisecond = other.getWaitMillisecond();
            return !(this$waitMillisecond == null ? other$waitMillisecond != null : !((Object)this$waitMillisecond).equals(other$waitMillisecond));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $stepMillisecond = this.getStepMillisecond();
            result = result * 59 + ($stepMillisecond == null ? 43 : ((Object)$stepMillisecond).hashCode());
            Long $waitMillisecond = this.getWaitMillisecond();
            result = result * 59 + ($waitMillisecond == null ? 43 : ((Object)$waitMillisecond).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TimeGenerator.Builder(stepMillisecond=" + this.getStepMillisecond() + ", waitMillisecond=" + this.getWaitMillisecond() + ")";
        }
    }
}

