/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.event;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.event.v3.Event;
import org.apache.skywalking.oap.server.analyzer.event.listener.EventAnalyzerListener;
import org.apache.skywalking.oap.server.analyzer.event.listener.IEventAnalyzerListenerManager;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventAnalyzer.class);
    private final ModuleManager moduleManager;
    private final IEventAnalyzerListenerManager factoryManager;
    private final List<EventAnalyzerListener> listeners = new ArrayList<EventAnalyzerListener>();

    public void analyze(Event builder) {
        this.createListeners();
        this.notifyListener(builder);
        this.notifyListenerToBuild();
    }

    private void notifyListener(Event event) {
        this.listeners.forEach(listener -> listener.parse(event));
    }

    private void notifyListenerToBuild() {
        this.listeners.forEach(EventAnalyzerListener::build);
    }

    private void createListeners() {
        this.factoryManager.getEventAnalyzerListenerFactories().forEach(factory -> this.listeners.add(factory.create(this.moduleManager)));
    }

    @Generated
    public EventAnalyzer(ModuleManager moduleManager, IEventAnalyzerListenerManager factoryManager) {
        this.moduleManager = moduleManager;
        this.factoryManager = factoryManager;
    }
}

