/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.generator;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.generator.Generator;

@JsonDeserialize(builder=Builder.class)
public final class ListGenerator<T>
implements Generator<Object, List<T>> {
    private final T item;
    private final int size;

    public ListGenerator(Builder<T> builder) {
        this.item = builder.item;
        this.size = builder.size;
    }

    @Override
    public List<T> next(Object ignored) {
        return IntStream.range(0, this.size).mapToObj($ -> this.item).collect(Collectors.toList());
    }

    @Override
    public void reset() {
        ((Generator)this.item).reset();
    }

    public static class Builder<T> {
        private int size;
        private T item;

        public ListGenerator<T> build() {
            return new ListGenerator(this);
        }

        @Generated
        public Builder() {
        }

        @Generated
        public int getSize() {
            return this.size;
        }

        @Generated
        public T getItem() {
            return this.item;
        }

        @Generated
        public void setSize(int size) {
            this.size = size;
        }

        @Generated
        public void setItem(T item) {
            this.item = item;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            T this$item = this.getItem();
            T other$item = other.getItem();
            return !(this$item == null ? other$item != null : !this$item.equals(other$item));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            T $item = this.getItem();
            result = result * 59 + ($item == null ? 43 : $item.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ListGenerator.Builder(size=" + this.getSize() + ", item=" + String.valueOf(this.getItem()) + ")";
        }
    }
}

