/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenu;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.core.storage.StorageData;
import org.apache.skywalking.oap.server.core.storage.management.UIMenuManagementDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.HashMapConverter;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.SQLExecutor;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.TableMetaInfo;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUIMenuManagementDAO
extends JDBCSQLExecutor
implements UIMenuManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JDBCUIMenuManagementDAO.class);
    private final JDBCClient h2Client;
    private final TableHelper tableHelper;

    public UIMenu getMenu(String id) throws IOException {
        List<String> tables = this.tableHelper.getTablesWithinTTL("ui_menu");
        for (String table : tables) {
            StringBuilder sql = new StringBuilder();
            ArrayList<String> condition = new ArrayList<String>(1);
            sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?").append(" and id=? LIMIT 1 ");
            condition.add("ui_menu");
            condition.add(id);
            UIMenu result = (UIMenu)this.h2Client.executeQuery(sql.toString(), resultSet -> {
                UIMenu.Builder builder = new UIMenu.Builder();
                return (UIMenu)this.toStorageData(resultSet, "ui_menu", (StorageBuilder<? extends StorageData>)builder);
            }, condition.toArray(new Object[0]));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void saveMenu(UIMenu menu) throws IOException {
        Model model = TableMetaInfo.get("ui_menu");
        SQLExecutor insertExecutor = this.getInsertExecutor(model, menu, 0L, new UIMenu.Builder(), (Convert2Storage<Map<String, Object>>)new HashMapConverter.ToStorage(), (SessionCacheCallback)null);
        try (Connection connection = this.h2Client.getConnection();){
            insertExecutor.invoke(connection);
        }
    }

    @Generated
    public JDBCUIMenuManagementDAO(JDBCClient h2Client, TableHelper tableHelper) {
        this.h2Client = h2Client;
        this.tableHelper = tableHelper;
    }
}

