/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import com.google.common.base.Strings;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ClusterModuleKubernetesConfig;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.KubernetesLabelSelectorEndpointGroup;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.UidEnvSupplier;
import org.apache.skywalking.oap.server.core.cluster.ClusterCoordinator;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceQueryException;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCoordinator
extends ClusterCoordinator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesCoordinator.class);
    private final ModuleDefineHolder manager;
    private volatile int port = -1;
    private HealthCheckMetrics healthChecker;
    private ClusterModuleKubernetesConfig config;
    private EndpointGroup endpointGroup;
    private volatile List<RemoteInstance> remoteInstances;

    public KubernetesCoordinator(ModuleDefineHolder manager, ClusterModuleKubernetesConfig config) {
        this.manager = manager;
        this.config = config;
        if (Strings.isNullOrEmpty((String)config.getLabelSelector())) {
            throw new IllegalArgumentException("kubernetes labelSelector must be provided");
        }
    }

    private EndpointGroup createEndpointGroup() {
        if (this.port == -1) {
            this.port = ((ConfigService)this.manager.find("core").provider().getService(ConfigService.class)).getGRPCPort();
        }
        KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
        KubernetesLabelSelectorEndpointGroup.Builder builder = KubernetesLabelSelectorEndpointGroup.builder(kubernetesClient);
        if (StringUtil.isNotBlank((String)this.config.getNamespace())) {
            builder.namespace(this.config.getNamespace());
        }
        Map<String, String> labelMap = this.parseLabelSelector(this.config.getLabelSelector());
        builder.labelSelector(labelMap);
        builder.port(this.port);
        builder.selfUid(new UidEnvSupplier(this.config.getUidEnvName()).get());
        return builder.build();
    }

    private Map<String, String> parseLabelSelector(String labelSelector) {
        String[] pairs;
        HashMap<String, String> labels = new HashMap<String, String>();
        if (StringUtil.isBlank((String)labelSelector)) {
            return labels;
        }
        for (String pair : pairs = labelSelector.split(",")) {
            String[] keyValue = pair.trim().split("=", 2);
            if (keyValue.length != 2) continue;
            labels.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return labels;
    }

    public List<RemoteInstance> queryRemoteNodes() {
        try {
            this.healthChecker.health();
            return this.remoteInstances;
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceQueryException(e.getMessage());
        }
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        try {
            this.port = remoteInstance.getAddress().getPort();
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    private void initHealthChecker() {
        if (this.healthChecker == null) {
            MetricsCreator metricCreator = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
            this.healthChecker = metricCreator.createHealthCheckerGauge("cluster_k8s", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
    }

    public void start() {
        this.endpointGroup = this.createEndpointGroup();
        this.endpointGroup.addListener(endpoints -> {
            if (this.port == -1) {
                this.port = ((ConfigService)this.manager.find("core").provider().getService(ConfigService.class)).getGRPCPort();
            }
            if (log.isDebugEnabled()) {
                log.debug("[kubernetes cluster endpoints]: {}", endpoints);
            }
            List<RemoteInstance> instances = endpoints.stream().map(endpoint -> new RemoteInstance(new Address(endpoint.host(), endpoint.port(), false))).collect(Collectors.toList());
            RemoteInstance selfInstance = new RemoteInstance(new Address("127.0.0.1", this.port, true));
            instances.add(selfInstance);
            if (log.isDebugEnabled()) {
                instances.forEach(instance -> log.debug("kubernetes cluster instance: {}", instance));
            }
            this.remoteInstances = instances;
            this.notifyWatchers(instances);
        }, true);
        this.initHealthChecker();
    }
}

