/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.module;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.BootstrapFlow;
import org.apache.skywalking.oap.server.library.module.CycleDependencyException;
import org.apache.skywalking.oap.server.library.module.ModuleConfigException;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleNotFoundException;
import org.apache.skywalking.oap.server.library.module.ModuleNotFoundRuntimeException;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleProviderHolder;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ProviderNotFoundException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.module.TerminalFriendlyTable;

public class ModuleManager
implements ModuleDefineHolder {
    private boolean isInPrepareStage = true;
    private final Map<String, ModuleDefine> loadedModules = new HashMap<String, ModuleDefine>();
    private final TerminalFriendlyTable bootingParameters;

    public ModuleManager(String description) {
        this.bootingParameters = new TerminalFriendlyTable(String.format("The key booting parameters of %s are listed as following.", description));
    }

    public void init(ApplicationConfiguration applicationConfiguration) throws ModuleNotFoundException, ProviderNotFoundException, ServiceNotProvidedException, CycleDependencyException, ModuleConfigException, ModuleStartException {
        String[] moduleNames = applicationConfiguration.moduleList();
        ServiceLoader<ModuleDefine> moduleServiceLoader = ServiceLoader.load(ModuleDefine.class);
        ServiceLoader<ModuleProvider> moduleProviderLoader = ServiceLoader.load(ModuleProvider.class);
        HashSet<String> moduleSet = new HashSet<String>(Arrays.asList(moduleNames));
        for (ModuleDefine module : moduleServiceLoader) {
            if (!moduleSet.contains(module.name())) continue;
            module.prepare(this, applicationConfiguration.getModuleConfiguration(module.name()), moduleProviderLoader, this.bootingParameters);
            this.loadedModules.put(module.name(), module);
            moduleSet.remove(module.name());
        }
        this.isInPrepareStage = false;
        if (moduleSet.size() > 0) {
            throw new ModuleNotFoundException(moduleSet.toString() + " missing.");
        }
        BootstrapFlow bootstrapFlow = new BootstrapFlow(this.loadedModules);
        bootstrapFlow.start(this);
        bootstrapFlow.notifyAfterCompleted();
    }

    @Override
    public boolean has(String moduleName) {
        return this.loadedModules.get(moduleName) != null;
    }

    @Override
    public ModuleProviderHolder find(String moduleName) throws ModuleNotFoundRuntimeException {
        this.assertPreparedStage();
        ModuleDefine module = this.loadedModules.get(moduleName);
        if (module != null) {
            return module;
        }
        throw new ModuleNotFoundRuntimeException(moduleName + " missing.");
    }

    private void assertPreparedStage() {
        if (this.isInPrepareStage) {
            throw new AssertionError((Object)"Still in preparing stage.");
        }
    }

    @Generated
    public TerminalFriendlyTable getBootingParameters() {
        return this.bootingParameters;
    }
}

