/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextHolder;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.Marker;

final class ContextAwareLogger
implements ContextHolder,
Logger {
    private final RequestContext ctx;
    private final Logger logger;

    static Logger of(RequestContext ctx, Logger logger) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(logger, "logger");
        if (logger instanceof ContextHolder) {
            RequestContextUtil.ensureSameCtx(ctx, (ContextHolder)((Object)logger), ContextAwareLogger.class);
            return logger;
        }
        return new ContextAwareLogger(ctx, logger);
    }

    private ContextAwareLogger(RequestContext ctx, Logger logger) {
        this.ctx = ctx;
        this.logger = logger;
    }

    @Override
    public RequestContext context() {
        return this.ctx;
    }

    private String decorate(String msg) {
        String prefix = this.ctx.toString();
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            String string = tempThreadLocals.stringBuilder().append(prefix).append(' ').append(msg).toString();
            return string;
        }
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(msg));
            }
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(format), arg);
            }
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(this.decorate(msg), t);
            }
        }
    }

    @Override
    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(msg));
            }
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(format), arg);
            }
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(format), argArray);
            }
        }
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.trace(marker, this.decorate(msg), t);
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(msg));
            }
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(format), arg);
            }
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(this.decorate(msg), t);
            }
        }
    }

    @Override
    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(msg));
            }
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(format), arg);
            }
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.debug(marker, this.decorate(msg), t);
            }
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(msg));
            }
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(format), arg);
            }
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(msg), t);
            }
        }
    }

    @Override
    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(marker, this.decorate(msg));
            }
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(this.decorate(format), (Object)format, arg);
            }
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(marker, this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.info(marker, this.decorate(msg), t);
            }
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(msg));
            }
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(format), arg);
            }
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(this.decorate(msg), t);
            }
        }
    }

    @Override
    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(msg));
            }
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(format), arg);
            }
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.warn(marker, this.decorate(msg), t);
            }
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(msg));
            }
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(format), arg);
            }
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(this.decorate(msg), t);
            }
        }
    }

    @Override
    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(msg));
            }
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(format), arg);
            }
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(format), arg1, arg2);
            }
        }
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(format), arguments);
            }
        }
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            try (SafeCloseable ignored = this.ctx.push();){
                this.logger.error(marker, this.decorate(msg), t);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("context", this.ctx).add("logger", this.logger).toString();
    }
}

