/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Objects;
import java.util.function.Predicate;

final class Inet4AddressBlock
implements Predicate<InetAddress> {
    private static final byte[] localhost = new byte[]{127, 0, 0, 1};
    private final Inet4Address baseAddress;
    private final int maskBits;
    private final int lowerBound;
    private final int upperBound;

    Inet4AddressBlock(Inet4Address baseAddress, int maskBits) {
        this.baseAddress = Objects.requireNonNull(baseAddress, "baseAddress");
        Preconditions.checkArgument(maskBits >= 0 && maskBits <= 32, "maskBits: %s (expected: 0-32)", maskBits);
        this.maskBits = maskBits;
        if (maskBits == 32) {
            this.lowerBound = this.upperBound = Inet4AddressBlock.ipv4AddressToInt(baseAddress.getAddress());
        } else if (maskBits == 0) {
            this.upperBound = 0;
            this.lowerBound = 0;
        } else {
            int mask = 1 << 32 - maskBits;
            this.lowerBound = Inet4AddressBlock.ipv4AddressToInt(baseAddress.getAddress()) & -mask;
            this.upperBound = this.lowerBound + mask - 1;
        }
    }

    @Override
    public boolean test(InetAddress address) {
        Objects.requireNonNull(address, "address");
        if (this.maskBits == 0) {
            return true;
        }
        byte[] bytes = address instanceof Inet6Address ? Inet4AddressBlock.ipv6ToIpv4Address((Inet6Address)address) : address.getAddress();
        if (bytes == null) {
            return false;
        }
        int addr = Inet4AddressBlock.ipv4AddressToInt(bytes);
        return addr >= this.lowerBound && addr <= this.upperBound;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("baseAddress", this.baseAddress).add("maskBits", this.maskBits).add("lowerBound", "0x" + Integer.toHexString(this.lowerBound)).add("upperBound", "0x" + Integer.toHexString(this.upperBound)).toString();
    }

    @Nullable
    static byte[] ipv6ToIpv4Address(Inet6Address address) {
        byte[] addr = address.getAddress();
        assert (addr.length == 16) : "the length of " + address.getClass().getSimpleName() + ": " + addr.length;
        for (int i = 0; i < 10; ++i) {
            if (addr[i] == 0) continue;
            return null;
        }
        if (addr[10] == 0 && addr[11] == 0) {
            if (addr[12] == 0 && addr[13] == 0 && addr[14] == 0 && addr[15] == 1) {
                return localhost;
            }
            return new byte[]{addr[12], addr[13], addr[14], addr[15]};
        }
        if (addr[10] == -1 && addr[11] == -1) {
            return new byte[]{addr[12], addr[13], addr[14], addr[15]};
        }
        return null;
    }

    private static int ipv4AddressToInt(byte[] address) {
        int val = 0;
        for (byte a : address) {
            val <<= 8;
            val |= a & 0xFF;
        }
        return val;
    }
}

