/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.ObjectCollectingUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ResponseConversionUtil {
    public static HttpResponseWriter aggregateFrom(Stream<?> stream, ResponseHeaders headers, HttpHeaders trailers, Function<Object, HttpData> contentConverter, Executor executor) {
        Objects.requireNonNull(stream, "stream");
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(contentConverter, "contentConverter");
        Objects.requireNonNull(executor, "executor");
        return ResponseConversionUtil.aggregateFrom(ObjectCollectingUtil.collectFrom(stream, executor), headers, trailers, contentConverter);
    }

    public static HttpResponseWriter aggregateFrom(Publisher<?> publisher, ResponseHeaders headers, HttpHeaders trailers, Function<Object, HttpData> contentConverter, ServiceRequestContext ctx) {
        Objects.requireNonNull(publisher, "publisher");
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(contentConverter, "contentConverter");
        return ResponseConversionUtil.aggregateFrom(ObjectCollectingUtil.collectFrom(publisher, ctx), headers, trailers, contentConverter);
    }

    private static HttpResponseWriter aggregateFrom(CompletableFuture<?> future, ResponseHeaders headers, HttpHeaders trailers, Function<Object, HttpData> contentConverter) {
        HttpResponseWriter writer = HttpResponse.streaming();
        future.handle((result, cause) -> {
            if (cause != null) {
                writer.close((Throwable)cause);
                return null;
            }
            try {
                HttpData content = (HttpData)contentConverter.apply(result);
                writer.write(headers);
                writer.write(content);
                if (!trailers.isEmpty()) {
                    writer.write(trailers);
                }
                writer.close();
            }
            catch (Exception e) {
                writer.close(e);
            }
            return null;
        });
        return writer;
    }

    public static <T> HttpResponseWriter streamingFrom(Stream<T> stream, ResponseHeaders headers, HttpHeaders trailers, Function<T, HttpData> contentConverter, Executor executor) {
        Objects.requireNonNull(stream, "stream");
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(contentConverter, "contentConverter");
        Objects.requireNonNull(executor, "executor");
        HttpResponseWriter writer = HttpResponse.streaming();
        executor.execute(() -> {
            try {
                Iterator it = ((Stream)stream.sequential()).iterator();
                boolean headerSent = false;
                while (it.hasNext()) {
                    HttpData content = (HttpData)contentConverter.apply(it.next());
                    if (!headerSent) {
                        writer.write(headers);
                        headerSent = true;
                    }
                    writer.write(content);
                }
                if (!trailers.isEmpty()) {
                    writer.write(trailers);
                }
                writer.close();
            }
            catch (Exception e) {
                writer.close(e);
            }
        });
        return writer;
    }

    public static <T> HttpResponseWriter streamingFrom(Publisher<T> publisher, ResponseHeaders headers, HttpHeaders trailers, Function<T, HttpData> contentConverter) {
        HttpResponseWriter writer = HttpResponse.streaming();
        publisher.subscribe(new StreamingSubscriber<T>(writer, headers, trailers, contentConverter));
        return writer;
    }

    private ResponseConversionUtil() {
    }

    private static final class StreamingSubscriber<T>
    implements Subscriber<T> {
        private final HttpResponseWriter writer;
        private final ResponseHeaders headers;
        private final HttpHeaders trailers;
        private final Function<T, HttpData> contentConverter;
        @Nullable
        private Subscription subscription;
        private boolean headersSent;

        StreamingSubscriber(HttpResponseWriter writer, ResponseHeaders headers, HttpHeaders trailers, Function<T, HttpData> contentConverter) {
            this.writer = Objects.requireNonNull(writer, "writer");
            this.headers = Objects.requireNonNull(headers, "headers");
            this.trailers = Objects.requireNonNull(trailers, "trailers");
            this.contentConverter = Objects.requireNonNull(contentConverter, "contentConverter");
        }

        @Override
        public void onSubscribe(Subscription s) {
            assert (this.subscription == null);
            this.subscription = s;
            this.writer.whenComplete().handle((unused, cause) -> {
                if (cause != null) {
                    s.cancel();
                }
                return null;
            });
            s.request(1L);
        }

        @Override
        public void onNext(T value) {
            if (!this.writer.isOpen()) {
                return;
            }
            try {
                HttpData content = this.contentConverter.apply(value);
                if (!this.headersSent) {
                    this.writer.write(this.headers);
                    this.headersSent = true;
                }
                this.writer.write(content);
                this.writer.whenConsumed().thenRun(() -> {
                    assert (this.subscription != null);
                    this.subscription.request(1L);
                });
            }
            catch (Exception e) {
                try {
                    this.writer.close(e);
                }
                finally {
                    assert (this.subscription != null);
                    this.subscription.cancel();
                }
            }
        }

        @Override
        public void onError(Throwable cause) {
            if (!this.writer.isOpen()) {
                return;
            }
            this.writer.close(cause);
        }

        @Override
        public void onComplete() {
            if (!this.writer.isOpen()) {
                return;
            }
            if (!this.trailers.isEmpty() && !this.writer.tryWrite(this.trailers)) {
                return;
            }
            this.writer.close();
        }
    }
}

