/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.kubernetes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.skywalking.library.kubernetes.ObjectID;
import org.slf4j.LoggerFactory;

public enum KubernetesServices {
    INSTANCE;

    private final LoadingCache<KubernetesServices, List<Service>> services;
    private final LoadingCache<ObjectID, Optional<Service>> serviceByID;

    private KubernetesServices() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(3L));
        this.services = cacheBuilder.build(CacheLoader.from(() -> {
            List list;
            block8: {
                KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
                try {
                    list = ((ServiceList)((AnyNamespaceOperation)kubernetesClient.services().inAnyNamespace()).list()).getItems();
                    if (kubernetesClient == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (kubernetesClient != null) {
                            try {
                                kubernetesClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Failed to list Services.", (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                kubernetesClient.close();
            }
            return list;
        }));
        this.serviceByID = cacheBuilder.build((CacheLoader)new CacheLoader<ObjectID, Optional<Service>>(){

            public Optional<Service> load(ObjectID id) {
                try (KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();){
                    Optional<Service> optional = Optional.ofNullable((Service)((ServiceResource)((NonNamespaceOperation)kubernetesClient.services().inNamespace(id.namespace())).withName(id.name())).get());
                    return optional;
                }
            }
        });
    }

    public List<Service> list() {
        return (List)this.services.get((Object)this);
    }

    public Optional<Service> findByID(ObjectID id) {
        return (Optional)this.serviceByID.get((Object)id);
    }
}

