/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeSeriesUtils {
    private static DateTimeFormatter TIME_BUCKET_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private static final DateTime DAY_ONE = TIME_BUCKET_FORMATTER.parseDateTime("20000101");
    private static int DAY_STEP = 1;
    private static int SUPER_DATASET_DAY_STEP = 1;

    public static String latestWriteIndexName(Model model) {
        String tableName = IndexController.INSTANCE.getTableName(model);
        long dayTimeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Day);
        if (model.isRecord() && model.isSuperDataset()) {
            return tableName + "-" + TimeSeriesUtils.compressTimeBucket(dayTimeBucket, SUPER_DATASET_DAY_STEP);
        }
        return tableName + "-" + TimeSeriesUtils.compressTimeBucket(dayTimeBucket, DAY_STEP);
    }

    public static String[] superDatasetIndexNames(String indexName, long startSecondTB, long endSecondTB) {
        if (startSecondTB == 0L || endSecondTB == 0L) {
            return new String[]{indexName};
        }
        DateTime startDateTime = TIME_BUCKET_FORMATTER.parseDateTime("" + startSecondTB / 1000000L);
        DateTime endDateTime = TIME_BUCKET_FORMATTER.parseDateTime("" + endSecondTB / 1000000L);
        ArrayList<DateTime> timeRanges = new ArrayList<DateTime>(16);
        for (int i = 0; i <= Days.daysBetween((ReadableInstant)startDateTime, (ReadableInstant)endDateTime).getDays(); ++i) {
            timeRanges.add(startDateTime.plusDays(i));
        }
        if (timeRanges.isEmpty()) {
            return new String[]{indexName};
        }
        return (String[])timeRanges.stream().map(item -> indexName + "-" + TimeSeriesUtils.compressDateTime(item, SUPER_DATASET_DAY_STEP)).distinct().toArray(String[]::new);
    }

    public static String queryIndexName(String tableName, long pointOfTB, Step step, boolean isRecord, boolean isSuperDataSet) {
        if (StringUtil.isBlank((String)tableName) || pointOfTB <= 0L) {
            throw new IllegalArgumentException("Arguments [tableName]: " + tableName + " can not be blank and [pointOfTB]: " + pointOfTB + " can not <= 0");
        }
        if (isRecord && isSuperDataSet) {
            return tableName + "-" + TimeSeriesUtils.compressTimeBucket(pointOfTB / 1000000L, SUPER_DATASET_DAY_STEP);
        }
        switch (step) {
            case DAY: {
                return tableName + "-" + TimeSeriesUtils.compressTimeBucket(pointOfTB, DAY_STEP);
            }
            case HOUR: {
                return tableName + "-" + TimeSeriesUtils.compressTimeBucket(pointOfTB / 100L, DAY_STEP);
            }
            case MINUTE: {
                return tableName + "-" + TimeSeriesUtils.compressTimeBucket(pointOfTB / 10000L, DAY_STEP);
            }
            case SECOND: {
                return tableName + "-" + TimeSeriesUtils.compressTimeBucket(pointOfTB / 1000000L, DAY_STEP);
            }
        }
        throw new UnexpectedException("Failed to get the index name from tableName:" + tableName + ", pointOfTB:" + pointOfTB + ", step:" + step.name());
    }

    static String writeIndexName(Model model, long timeBucket) {
        String tableName = IndexController.INSTANCE.getTableName(model);
        if (model.isRecord() && model.isSuperDataset()) {
            return tableName + "-" + TimeSeriesUtils.compressTimeBucket(timeBucket / 1000000L, SUPER_DATASET_DAY_STEP);
        }
        switch (model.getDownsampling()) {
            case None: {
                return tableName;
            }
            case Hour: {
                return tableName + "-" + TimeSeriesUtils.compressTimeBucket(timeBucket / 100L, DAY_STEP);
            }
            case Minute: {
                return tableName + "-" + TimeSeriesUtils.compressTimeBucket(timeBucket / 10000L, DAY_STEP);
            }
            case Day: {
                return tableName + "-" + TimeSeriesUtils.compressTimeBucket(timeBucket, DAY_STEP);
            }
            case Second: {
                return tableName + "-" + TimeSeriesUtils.compressTimeBucket(timeBucket / 1000000L, DAY_STEP);
            }
        }
        throw new UnexpectedException("Unexpected down sampling value, " + String.valueOf(model.getDownsampling()));
    }

    static long isolateTimeFromIndexName(String indexName) {
        return Long.parseLong(indexName.substring(indexName.lastIndexOf("-") + 1));
    }

    static long compressTimeBucket(long timeBucket, int dayStep) {
        if (dayStep > 1) {
            DateTime time = TIME_BUCKET_FORMATTER.parseDateTime("" + timeBucket);
            int days = Days.daysBetween((ReadableInstant)DAY_ONE, (ReadableInstant)time).getDays();
            int groupBucketOffset = days % dayStep;
            return Long.parseLong(time.minusDays(groupBucketOffset).toString(TIME_BUCKET_FORMATTER));
        }
        return timeBucket;
    }

    static long compressDateTime(DateTime time, int dayStep) {
        if (dayStep > 1) {
            int days = Days.daysBetween((ReadableInstant)DAY_ONE, (ReadableInstant)time).getDays();
            int groupBucketOffset = days % dayStep;
            return Long.parseLong(time.minusDays(groupBucketOffset).toString(TIME_BUCKET_FORMATTER));
        }
        return Long.parseLong(time.toString(TIME_BUCKET_FORMATTER));
    }

    @Generated
    public static void setDAY_STEP(int DAY_STEP) {
        TimeSeriesUtils.DAY_STEP = DAY_STEP;
    }

    @Generated
    public static void setSUPER_DATASET_DAY_STEP(int SUPER_DATASET_DAY_STEP) {
        TimeSeriesUtils.SUPER_DATASET_DAY_STEP = SUPER_DATASET_DAY_STEP;
    }
}

