/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.util.List;
import java.util.Map;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingDataRecord;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingDataDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchScroller;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class EBPFProfilingDataEsDAO
extends EsDAO
implements IEBPFProfilingDataDAO {
    private final int scrollingBatchSize;

    public EBPFProfilingDataEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.scrollingBatchSize = config.getProfileDataQueryBatchSize();
    }

    public List<EBPFProfilingDataRecord> queryData(List<String> scheduleIdList, long beginTime, long endTime) {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_data");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("ebpf_profiling_data")) {
            query.must((QueryBuilder)Query.term((String)"record_table", (Object)"ebpf_profiling_data"));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)query).size(Integer.valueOf(this.scrollingBatchSize));
        query.must((QueryBuilder)Query.terms((String)"schedule_id", scheduleIdList));
        query.must((QueryBuilder)Query.range((String)"upload_time").gte((Object)beginTime).lt((Object)endTime));
        ElasticSearchScroller scroller = ElasticSearchScroller.builder().client((ElasticSearchClient)this.getClient()).search(search.build()).index(index).resultConverter(hit -> {
            Map sourceAsMap = hit.getSource();
            EBPFProfilingDataRecord.Builder builder = new EBPFProfilingDataRecord.Builder();
            return builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ebpf_profiling_data", sourceAsMap));
        }).build();
        return scroller.scroll();
    }
}

