/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.v1.client.Tag;

public class Span {
    private Timestamp startTime;
    private Timestamp endTime;
    private boolean error;
    private List<Tag> tags;
    private String message;
    private List<Span> children;
    private long duration;

    static Span convertSpanFromProto(BanyandbCommon.Span protoSpan) {
        Span spanBean = new Span();
        spanBean.setStartTime(protoSpan.getStartTime());
        spanBean.setEndTime(protoSpan.getEndTime());
        spanBean.setError(protoSpan.getError());
        spanBean.setMessage(protoSpan.getMessage());
        spanBean.setDuration(protoSpan.getDuration());
        spanBean.setTags(protoSpan.getTagsList().stream().map(Tag::convertTagFromProto).collect(Collectors.toList()));
        spanBean.setChildren(protoSpan.getChildrenList().stream().map(Span::convertSpanFromProto).collect(Collectors.toList()));
        return spanBean;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public boolean isError() {
        return this.error;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Span> getChildren() {
        return this.children;
    }

    public long getDuration() {
        return this.duration;
    }

    private void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    private void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    private void setError(boolean error) {
        this.error = error;
    }

    private void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    private void setMessage(String message) {
        this.message = message;
    }

    private void setChildren(List<Span> children) {
        this.children = children;
    }

    private void setDuration(long duration) {
        this.duration = duration;
    }
}

