/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;

public class TopNQuery {
    private final List<String> groups;
    private final String name;
    private final TimestampRange timestampRange;
    private final int number;
    private final AbstractQuery.Sort sort;
    private MeasureQuery.Aggregation.Type aggregationType = MeasureQuery.Aggregation.Type.UNSPECIFIED;
    private List<String> stages;
    private List<PairQueryCondition<?>> conditions;

    public TopNQuery(List<String> groups, String name, TimestampRange timestampRange, int number, AbstractQuery.Sort sort) {
        Preconditions.checkArgument((sort != AbstractQuery.Sort.UNSPECIFIED ? 1 : 0) != 0);
        Preconditions.checkArgument((number > 0 ? 1 : 0) != 0);
        this.groups = groups;
        this.name = name;
        this.timestampRange = timestampRange;
        this.number = number;
        this.sort = sort;
    }

    BanyandbMeasure.TopNRequest build() throws BanyanDBException {
        BanyandbMeasure.TopNRequest.Builder bld = BanyandbMeasure.TopNRequest.newBuilder().setName(this.name).addAllGroups(this.groups).setTimeRange(this.timestampRange.build()).setTopN(this.number).setFieldValueSort(AbstractQuery.Sort.DESC == this.sort ? BanyandbModel.Sort.SORT_DESC : BanyandbModel.Sort.SORT_ASC);
        if (this.aggregationType == null) {
            bld.setAgg(BanyandbModel.AggregationFunction.AGGREGATION_FUNCTION_UNSPECIFIED);
        } else {
            bld.setAgg(this.aggregationType.function);
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            for (PairQueryCondition pairQueryCondition : this.conditions) {
                if (pairQueryCondition.op != BanyandbModel.Condition.BinaryOp.BINARY_OP_EQ) {
                    throw new UnsupportedOperationException("only equality is supported");
                }
                bld.addConditions(pairQueryCondition.build().getCondition());
            }
        }
        if (this.stages != null && !this.stages.isEmpty()) {
            for (String string : this.stages) {
                bld.addStages(string);
            }
        }
        return bld.build();
    }

    public void setAggregationType(MeasureQuery.Aggregation.Type aggregationType) {
        this.aggregationType = aggregationType;
    }

    public void setStages(List<String> stages) {
        this.stages = stages;
    }

    public void setConditions(List<PairQueryCondition<?>> conditions) {
        this.conditions = conditions;
    }
}

