/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.client;

import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.requests.IndexRequest;
import org.apache.skywalking.library.elasticsearch.requests.UpdateRequest;
import org.apache.skywalking.library.elasticsearch.response.Document;
import org.apache.skywalking.library.elasticsearch.response.Documents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocumentClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentClient.class);
    private final CompletableFuture<ElasticSearchVersion> version;
    private final WebClient client;

    public boolean exists(String index, String type, String id) {
        return (Boolean)((CompletableFuture)this.version.thenCompose(v -> ((CompletableFuture)this.client.execute(v.requestFactory().document().exist(index, type, id)).aggregate().thenApply(response -> response.status() == HttpStatus.OK)).exceptionally(e -> {
            log.error("Failed to check whether document exists", e);
            return false;
        }))).get();
    }

    public Optional<Document> get(String index, String type, String id) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().document().get(index, type, id)).aggregate().thenApply(response -> {
            if (response.status() != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
            try (HttpData content = response.content();){
                Optional<Document> optional;
                block19: {
                    Document document;
                    InputStream is;
                    block17: {
                        Optional optional2;
                        block18: {
                            is = content.toInputStream();
                            try {
                                document = v.codec().decode(is, Document.class);
                                if (document.isFound()) break block17;
                                optional2 = Optional.empty();
                                if (is == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            is.close();
                        }
                        return optional2;
                    }
                    optional = Optional.of(document);
                    if (is == null) break block19;
                    is.close();
                }
                return optional;
            }
            catch (Exception e) {
                return (Optional)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to get doc by id {} in index {}", new Object[]{id, index, exception});
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Doc by id {} in index {}: {}", new Object[]{id, index, result});
            }
        });
        return (Optional)((CompletableFuture)future).get();
    }

    public Optional<Documents> mget(String type, Map<String, List<String>> indexIds) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().document().mget(type, indexIds)).aggregate().thenApply(response -> {
            if (response.status() != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
            try (HttpData content = response.content();){
                Optional<Documents> optional;
                block15: {
                    InputStream is = content.toInputStream();
                    try {
                        optional = Optional.of(v.codec().decode(is, Documents.class));
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return optional;
            }
            catch (Exception e) {
                return (Optional)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to get doc by indexIds {}", (Object)indexIds, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Docs by indexIds {}: {}", (Object)indexIds, result);
            }
        });
        return (Optional)((CompletableFuture)future).get();
    }

    public void index(IndexRequest request, Map<String, Object> params) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().document().index(request, params)).aggregate().thenAccept(response -> {
            HttpStatus status = response.status();
            if (status != HttpStatus.CREATED && status != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to index doc: {}, params: {}", new Object[]{request, params, exception});
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded indexing doc: {}, params: {}", (Object)request, (Object)params);
            }
        });
        ((CompletableFuture)future).join();
    }

    public void update(UpdateRequest request, Map<String, Object> params) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().document().update(request, params)).aggregate().thenAccept(response -> {
            HttpStatus status = response.status();
            if (status != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to update doc: {}, params: {}", new Object[]{request, params, exception});
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded updating doc: {}, params: {}", (Object)request, (Object)params);
            }
        });
        ((CompletableFuture)future).join();
    }

    public void deleteById(String index, String type, String id, Map<String, Object> params) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().document().deleteById(index, type, id, params)).aggregate().thenAccept(response -> {
            HttpStatus status = response.status();
            if (status != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to delete doc by id {} in index {}, params: {}", new Object[]{id, index, params, exception});
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Succeeded delete doc by id {} in index {}, params: {}", new Object[]{id, params, index});
            }
        });
        ((CompletableFuture)future).join();
    }

    @Generated
    public DocumentClient(CompletableFuture<ElasticSearchVersion> version, WebClient client) {
        this.version = version;
        this.client = client;
    }
}

