/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ErrorType;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@PublicApi
public class AbortExecutionException
extends GraphQLException
implements GraphQLError {
    private final List<GraphQLError> underlyingErrors;

    public AbortExecutionException() {
        this.underlyingErrors = ImmutableKit.emptyList();
    }

    public AbortExecutionException(Collection<GraphQLError> underlyingErrors) {
        this.underlyingErrors = new ArrayList<GraphQLError>(Assert.assertNotNull(underlyingErrors));
    }

    public AbortExecutionException(String message) {
        super(message);
        this.underlyingErrors = ImmutableKit.emptyList();
    }

    public AbortExecutionException(String message, Throwable cause) {
        super(message, cause);
        this.underlyingErrors = ImmutableKit.emptyList();
    }

    public AbortExecutionException(Throwable cause) {
        super(cause);
        this.underlyingErrors = ImmutableKit.emptyList();
    }

    @Override
    public List<SourceLocation> getLocations() {
        return null;
    }

    @Override
    public ErrorType getErrorType() {
        return ErrorType.ExecutionAborted;
    }

    public List<GraphQLError> getUnderlyingErrors() {
        return this.underlyingErrors;
    }

    public ExecutionResult toExecutionResult() {
        if (!this.getUnderlyingErrors().isEmpty()) {
            return new ExecutionResultImpl(this.getUnderlyingErrors());
        }
        return new ExecutionResultImpl(this);
    }
}

