/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation;

import graphql.Assert;
import graphql.PublicApi;
import graphql.collect.ImmutableMapWithNullValues;
import graphql.language.Document;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class DocumentAndVariables {
    private final Document document;
    private final ImmutableMapWithNullValues<String, Object> variables;

    private DocumentAndVariables(Document document, Map<String, Object> variables) {
        this.document = Assert.assertNotNull(document);
        this.variables = ImmutableMapWithNullValues.copyOf(Assert.assertNotNull(variables));
    }

    public Document getDocument() {
        return this.document;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public DocumentAndVariables transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder().document(this.document).variables(this.variables);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newDocumentAndVariables() {
        return new Builder();
    }

    public static class Builder {
        private Document document;
        private Map<String, Object> variables;

        public Builder document(Document document) {
            this.document = document;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public DocumentAndVariables build() {
            return new DocumentAndVariables(this.document, this.variables);
        }
    }
}

