/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.provider;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.analyzer.provider.trace.CacheReadLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.CacheWriteLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.DBLatencyThresholdsAndWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.TraceSamplingPolicyWatcher;
import org.apache.skywalking.oap.server.analyzer.provider.trace.UninstrumentedGatewaysConfig;
import org.apache.skywalking.oap.server.analyzer.provider.trace.parser.listener.strategy.SegmentStatusStrategy;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerModuleConfig
extends ModuleConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyzerModuleConfig.class);
    private String traceSamplingPolicySettingsFile;
    private String noUpstreamRealAddressAgents = "";
    private String slowDBAccessThreshold = "default:200";
    private DBLatencyThresholdsAndWatcher dbLatencyThresholdsAndWatcher;
    private String slowCacheWriteThreshold = "default:20,redis:10";
    private CacheWriteLatencyThresholdsAndWatcher cacheWriteLatencyThresholdsAndWatcher;
    private String slowCacheReadThreshold = "default:20,redis:10";
    private CacheReadLatencyThresholdsAndWatcher cacheReadLatencyThresholdsAndWatcher;
    private UninstrumentedGatewaysConfig uninstrumentedGatewaysConfig;
    private TraceSamplingPolicyWatcher traceSamplingPolicyWatcher;
    private boolean traceAnalysis = true;
    private int maxSlowSQLLength = 2000;
    private final String configPath = "meter-analyzer-config";
    private String meterAnalyzerActiveFiles = "";
    private boolean forceSampleErrorSegment = true;
    private String segmentStatusAnalysisStrategy = SegmentStatusStrategy.FROM_SPAN_STATUS.name();
    private List<Integer> virtualPeers;

    public boolean shouldIgnorePeerIPDue2Virtual(int componentId) {
        if (this.virtualPeers == null) {
            this.virtualPeers = new ArrayList<Integer>(20);
            for (String component : this.noUpstreamRealAddressAgents.split(",")) {
                try {
                    this.virtualPeers.add(Integer.parseInt(component));
                }
                catch (NumberFormatException e) {
                    log.warn("noUpstreamRealAddressAgents config {} includes illegal value {}", (Object)this.noUpstreamRealAddressAgents, (Object)component);
                }
            }
        }
        return this.virtualPeers.contains(componentId);
    }

    public List<String> meterAnalyzerActiveFileNames() {
        if (StringUtils.isEmpty((CharSequence)this.meterAnalyzerActiveFiles)) {
            return null;
        }
        return Splitter.on((String)",").splitToList((CharSequence)this.meterAnalyzerActiveFiles);
    }

    @Generated
    public void setTraceSamplingPolicySettingsFile(String traceSamplingPolicySettingsFile) {
        this.traceSamplingPolicySettingsFile = traceSamplingPolicySettingsFile;
    }

    @Generated
    public String getTraceSamplingPolicySettingsFile() {
        return this.traceSamplingPolicySettingsFile;
    }

    @Generated
    public String getNoUpstreamRealAddressAgents() {
        return this.noUpstreamRealAddressAgents;
    }

    @Generated
    public void setSlowDBAccessThreshold(String slowDBAccessThreshold) {
        this.slowDBAccessThreshold = slowDBAccessThreshold;
    }

    @Generated
    public String getSlowDBAccessThreshold() {
        return this.slowDBAccessThreshold;
    }

    @Generated
    public void setDbLatencyThresholdsAndWatcher(DBLatencyThresholdsAndWatcher dbLatencyThresholdsAndWatcher) {
        this.dbLatencyThresholdsAndWatcher = dbLatencyThresholdsAndWatcher;
    }

    @Generated
    public DBLatencyThresholdsAndWatcher getDbLatencyThresholdsAndWatcher() {
        return this.dbLatencyThresholdsAndWatcher;
    }

    @Generated
    public void setSlowCacheWriteThreshold(String slowCacheWriteThreshold) {
        this.slowCacheWriteThreshold = slowCacheWriteThreshold;
    }

    @Generated
    public String getSlowCacheWriteThreshold() {
        return this.slowCacheWriteThreshold;
    }

    @Generated
    public void setCacheWriteLatencyThresholdsAndWatcher(CacheWriteLatencyThresholdsAndWatcher cacheWriteLatencyThresholdsAndWatcher) {
        this.cacheWriteLatencyThresholdsAndWatcher = cacheWriteLatencyThresholdsAndWatcher;
    }

    @Generated
    public CacheWriteLatencyThresholdsAndWatcher getCacheWriteLatencyThresholdsAndWatcher() {
        return this.cacheWriteLatencyThresholdsAndWatcher;
    }

    @Generated
    public void setSlowCacheReadThreshold(String slowCacheReadThreshold) {
        this.slowCacheReadThreshold = slowCacheReadThreshold;
    }

    @Generated
    public String getSlowCacheReadThreshold() {
        return this.slowCacheReadThreshold;
    }

    @Generated
    public void setCacheReadLatencyThresholdsAndWatcher(CacheReadLatencyThresholdsAndWatcher cacheReadLatencyThresholdsAndWatcher) {
        this.cacheReadLatencyThresholdsAndWatcher = cacheReadLatencyThresholdsAndWatcher;
    }

    @Generated
    public CacheReadLatencyThresholdsAndWatcher getCacheReadLatencyThresholdsAndWatcher() {
        return this.cacheReadLatencyThresholdsAndWatcher;
    }

    @Generated
    public void setUninstrumentedGatewaysConfig(UninstrumentedGatewaysConfig uninstrumentedGatewaysConfig) {
        this.uninstrumentedGatewaysConfig = uninstrumentedGatewaysConfig;
    }

    @Generated
    public UninstrumentedGatewaysConfig getUninstrumentedGatewaysConfig() {
        return this.uninstrumentedGatewaysConfig;
    }

    @Generated
    public void setTraceSamplingPolicyWatcher(TraceSamplingPolicyWatcher traceSamplingPolicyWatcher) {
        this.traceSamplingPolicyWatcher = traceSamplingPolicyWatcher;
    }

    @Generated
    public TraceSamplingPolicyWatcher getTraceSamplingPolicyWatcher() {
        return this.traceSamplingPolicyWatcher;
    }

    @Generated
    public void setTraceAnalysis(boolean traceAnalysis) {
        this.traceAnalysis = traceAnalysis;
    }

    @Generated
    public boolean isTraceAnalysis() {
        return this.traceAnalysis;
    }

    @Generated
    public void setMaxSlowSQLLength(int maxSlowSQLLength) {
        this.maxSlowSQLLength = maxSlowSQLLength;
    }

    @Generated
    public int getMaxSlowSQLLength() {
        return this.maxSlowSQLLength;
    }

    @Generated
    public String getConfigPath() {
        return this.configPath;
    }

    @Generated
    public void setMeterAnalyzerActiveFiles(String meterAnalyzerActiveFiles) {
        this.meterAnalyzerActiveFiles = meterAnalyzerActiveFiles;
    }

    @Generated
    public void setForceSampleErrorSegment(boolean forceSampleErrorSegment) {
        this.forceSampleErrorSegment = forceSampleErrorSegment;
    }

    @Generated
    public boolean isForceSampleErrorSegment() {
        return this.forceSampleErrorSegment;
    }

    @Generated
    public void setSegmentStatusAnalysisStrategy(String segmentStatusAnalysisStrategy) {
        this.segmentStatusAnalysisStrategy = segmentStatusAnalysisStrategy;
    }

    @Generated
    public String getSegmentStatusAnalysisStrategy() {
        return this.segmentStatusAnalysisStrategy;
    }
}

