/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.encoding;

import com.linecorp.armeria.common.encoding.BrotliStreamDecoder;
import com.linecorp.armeria.common.encoding.SnappyStreamDecoder;
import com.linecorp.armeria.common.encoding.StreamDecoder;
import com.linecorp.armeria.common.encoding.StreamDecoderFactory;
import com.linecorp.armeria.common.encoding.ZlibStreamDecoder;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import java.util.List;

enum StreamDecoderFactories implements StreamDecoderFactory
{
    BROTLI{

        @Override
        public String encodingHeaderValue() {
            return "br";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc, int maxLength) {
            return new BrotliStreamDecoder(new BrotliDecoder(), alloc, maxLength);
        }
    }
    ,
    GZIP{

        @Override
        public String encodingHeaderValue() {
            return "gzip";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc, int maxLength) {
            return new ZlibStreamDecoder(ZlibWrapper.GZIP, alloc, maxLength);
        }
    }
    ,
    DEFLATE{

        @Override
        public String encodingHeaderValue() {
            return "deflate";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc, int maxLength) {
            return new ZlibStreamDecoder(ZlibWrapper.ZLIB, alloc, maxLength);
        }
    }
    ,
    SNAPPY{

        @Override
        public String encodingHeaderValue() {
            return "x-snappy-framed";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc, int maxLength) {
            return new SnappyStreamDecoder(new SnappyFrameDecoder(), alloc, maxLength);
        }
    };

    static final List<StreamDecoderFactory> ALL;

    static {
        ALL = Brotli.isAvailable() ? ImmutableList.copyOf(StreamDecoderFactories.values()) : ImmutableList.of(GZIP, DEFLATE, SNAPPY);
    }
}

