/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class NoopSubscriber<T>
implements Subscriber<T> {
    private static final NoopSubscriber<?> INSTANCE = new NoopSubscriber();

    public static <T> NoopSubscriber<T> get() {
        return INSTANCE;
    }

    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T item) {
        Objects.requireNonNull(item, "item");
        StreamMessageUtil.closeOrAbort(item);
    }

    public void onError(Throwable t) {
    }

    public void onComplete() {
    }
}

