/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.NonBlocking;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLoopCheckingFuture<T>
extends CompletableFuture<T> {
    private static final Logger logger = LoggerFactory.getLogger(EventLoopCheckingFuture.class);
    private static final Set<Thread> REPORTED_THREADS = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    public static <U> EventLoopCheckingFuture<U> completedFuture(@Nullable U value) {
        EventLoopCheckingFuture<U> future = new EventLoopCheckingFuture<U>();
        future.complete(value);
        return future;
    }

    public static <U> EventLoopCheckingFuture<U> exceptionallyCompletedFuture(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        EventLoopCheckingFuture future = new EventLoopCheckingFuture();
        future.completeExceptionally(cause);
        return future;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.maybeLogIfOnEventLoop();
        return super.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.maybeLogIfOnEventLoop();
        return super.get(timeout, unit);
    }

    @Override
    public T join() {
        this.maybeLogIfOnEventLoop();
        return super.join();
    }

    private void maybeLogIfOnEventLoop() {
        if (!Flags.reportBlockedEventLoop() || this.isDone()) {
            return;
        }
        Thread thread = Thread.currentThread();
        if (thread instanceof NonBlocking && REPORTED_THREADS.add(thread)) {
            logger.warn("Calling a blocking method on CompletableFuture from an event loop or non-blocking thread. You should never do this as this will usually result in significantly reduced performance of the server, generally crippling its ability to handle high load, or even result in deadlock which cannot be recovered from. Use ServiceRequestContext.blockingExecutor to run this logic instead or switch to using asynchronous methods like thenApply. If you really believe it is fine to block the event loop like this, you can disable this log message by specifying the -Dcom.linecorp.armeria.reportBlockedEventLoop=false JVM option.", (Throwable)new IllegalStateException("Blocking event loop, don't do this."));
        }
    }
}

