/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import java.net.IDN;
import java.util.Locale;

public final class TlsProviderUtil {
    public static String normalizeHostname(String hostname) {
        if (hostname.isEmpty() || hostname.charAt(0) == '.') {
            throw new IllegalArgumentException("Hostname '" + hostname + "' not valid");
        }
        if (TlsProviderUtil.needsNormalization(hostname)) {
            hostname = IDN.toASCII(hostname, 1);
        }
        if ((hostname = hostname.toLowerCase(Locale.US)).charAt(0) == '*') {
            if (hostname.length() < 3 || hostname.charAt(1) != '.') {
                throw new IllegalArgumentException("Wildcard Hostname '" + hostname + "'not valid");
            }
            return hostname.substring(1);
        }
        return hostname;
    }

    private static boolean needsNormalization(String hostname) {
        int length = hostname.length();
        for (int i = 0; i < length; ++i) {
            char c = hostname.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private TlsProviderUtil() {
    }
}

