/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingResultType;
import java.util.Objects;

public final class RoutingResultBuilder {
    private RoutingResultType type = RoutingResultType.MATCHED;
    @Nullable
    private String path;
    @Nullable
    private String query;
    @Nullable
    private ImmutableMap.Builder<String, String> pathParams;
    private int score = Integer.MIN_VALUE;
    @Nullable
    private MediaType negotiatedResponseMediaType;

    RoutingResultBuilder() {
    }

    RoutingResultBuilder(int expectedNumParams) {
        this.pathParams = ImmutableMap.builderWithExpectedSize(expectedNumParams);
    }

    public RoutingResultBuilder type(RoutingResultType type) {
        Objects.requireNonNull(type, "type");
        Preconditions.checkArgument(type != RoutingResultType.NOT_MATCHED, "type: %s (expected: %s or %s)", (Object)type, (Object)RoutingResultType.MATCHED, (Object)RoutingResultType.CORS_PREFLIGHT);
        this.type = type;
        return this;
    }

    public RoutingResultBuilder path(String path) {
        this.path = Objects.requireNonNull(path, "path");
        return this;
    }

    public RoutingResultBuilder query(@Nullable String query) {
        this.query = query;
        return this;
    }

    public RoutingResultBuilder decodedParam(String name, String value) {
        this.pathParams().put(Objects.requireNonNull(name, "name"), Objects.requireNonNull(value, "value"));
        return this;
    }

    public RoutingResultBuilder rawParam(String name, String value) {
        this.pathParams().put(Objects.requireNonNull(name, "name"), ArmeriaHttpUtil.decodePathParam(Objects.requireNonNull(value, "value")));
        return this;
    }

    public RoutingResultBuilder score(int score) {
        this.score = score;
        return this;
    }

    public RoutingResultBuilder negotiatedResponseMediaType(MediaType negotiatedResponseMediaType) {
        this.negotiatedResponseMediaType = Objects.requireNonNull(negotiatedResponseMediaType, "negotiatedResponseMediaType");
        return this;
    }

    public RoutingResult build() {
        if (this.path == null) {
            return RoutingResult.empty();
        }
        return new RoutingResult(this.type, this.path, this.query, this.pathParams != null ? this.pathParams.build() : ImmutableMap.of(), this.score, this.negotiatedResponseMediaType);
    }

    private ImmutableMap.Builder<String, String> pathParams() {
        if (this.pathParams != null) {
            return this.pathParams;
        }
        this.pathParams = ImmutableMap.builder();
        return this.pathParams;
    }
}

