/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.websocket;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;

public final class WebSocketUpgradeResult {
    private static final WebSocketUpgradeResult SUCCESS = new WebSocketUpgradeResult(null);
    @Nullable
    private final HttpResponse fallbackResponse;

    public static WebSocketUpgradeResult ofSuccess() {
        return SUCCESS;
    }

    public static WebSocketUpgradeResult ofFailure(HttpResponse fallbackResponse) {
        Objects.requireNonNull(fallbackResponse, "failureResponse");
        return new WebSocketUpgradeResult(fallbackResponse);
    }

    private WebSocketUpgradeResult(@Nullable HttpResponse fallbackResponse) {
        this.fallbackResponse = fallbackResponse;
    }

    public boolean isSuccess() {
        return this.fallbackResponse == null;
    }

    public HttpResponse fallbackResponse() {
        if (this.fallbackResponse == null) {
            throw new IllegalStateException("WebSocket was successfully upgraded.");
        }
        return this.fallbackResponse;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "WebSocketUpgradeResult(success)";
        }
        return MoreObjects.toStringHelper(this).add("fallback", this.fallbackResponse).toString();
    }
}

