/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluentImpl;

public class RoleBindingBuilder
extends RoleBindingFluentImpl<RoleBindingBuilder>
implements VisitableBuilder<RoleBinding, RoleBindingBuilder> {
    RoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public RoleBindingBuilder() {
        this(false);
    }

    public RoleBindingBuilder(Boolean validationEnabled) {
        this(new RoleBinding(), validationEnabled);
    }

    public RoleBindingBuilder(RoleBindingFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RoleBindingBuilder(RoleBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RoleBinding(), validationEnabled);
    }

    public RoleBindingBuilder(RoleBindingFluent<?> fluent, RoleBinding instance) {
        this(fluent, instance, false);
    }

    public RoleBindingBuilder(RoleBindingFluent<?> fluent, RoleBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withRoleRef(instance.getRoleRef());
            fluent.withSubjects(instance.getSubjects());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public RoleBindingBuilder(RoleBinding instance) {
        this(instance, (Boolean)false);
    }

    public RoleBindingBuilder(RoleBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRoleRef(instance.getRoleRef());
            this.withSubjects(instance.getSubjects());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public RoleBinding build() {
        RoleBinding buildable = new RoleBinding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRoleRef(), this.fluent.getSubjects());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

