/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricStreamKind;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsPersistentWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsTransWorker;
import org.apache.skywalking.oap.server.core.exporter.ExportEvent;
import org.apache.skywalking.oap.server.core.status.ServerStatusService;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.QueueBuffer;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.GaugeMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetricsPersistentMinWorker
extends MetricsPersistentWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsPersistentMinWorker.class);
    private final DataCarrier<Metrics> dataCarrier;
    private final GaugeMetrics queuePercentageGauge;
    private final ServerStatusService serverStatusService;
    private final boolean isTestingTTL = "true".equalsIgnoreCase(System.getenv("TESTING_TTL"));
    private final int queueTotalSize;

    MetricsPersistentMinWorker(ModuleDefineHolder moduleDefineHolder, Model model, IMetricsDAO metricsDAO, AbstractWorker<Metrics> nextAlarmWorker, AbstractWorker<ExportEvent> nextExportWorker, MetricsTransWorker transWorker, boolean supportUpdate, long storageSessionTimeout, int metricsDataTTL, MetricStreamKind kind, String poolName, int poolSize, boolean isSignalDrivenMode, int queueChannelSize, int queueBufferSize) {
        super(moduleDefineHolder, model, metricsDAO, nextAlarmWorker, nextExportWorker, transWorker, supportUpdate, storageSessionTimeout, metricsDataTTL, kind);
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(poolName, poolSize, 200L, isSignalDrivenMode);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(poolName, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.dataCarrier = new DataCarrier("MetricsPersistentWorker." + model.getName(), poolName, queueChannelSize, queueBufferSize);
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(poolName), (IConsumer)new PersistentConsumer());
        MetricsCreator metricsCreator = (MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class);
        this.queuePercentageGauge = metricsCreator.createGauge("metrics_aggregation_queue_used_percentage", "The percentage of queue used in aggregation.", new MetricsTag.Keys(new String[]{"metricName", "level", "kind"}), new MetricsTag.Values(new String[]{model.getName(), "2", kind.name()}));
        this.serverStatusService = (ServerStatusService)moduleDefineHolder.find("core").provider().getService(ServerStatusService.class);
        this.serverStatusService.registerWatcher(this);
        this.queueTotalSize = Arrays.stream(this.dataCarrier.getChannels().getBufferChannels()).mapToInt(QueueBuffer::getBufferSize).sum();
    }

    @Override
    public void in(Metrics metrics) {
        boolean isExpired = this.getMetricsDAO().isExpiredCache(this.getModel(), metrics, System.currentTimeMillis(), this.getMetricsDataTTL());
        if (isExpired && !this.isTestingTTL) {
            log.debug("Receiving expired metrics: {}, time: {}, ignored", (Object)metrics.id(), (Object)metrics.getTimeBucket());
            return;
        }
        this.getAggregationCounter().inc();
        this.dataCarrier.produce((Object)metrics);
    }

    private class PersistentConsumer
    implements IConsumer<Metrics> {
        private PersistentConsumer() {
        }

        public void consume(List<Metrics> data) {
            MetricsPersistentMinWorker.this.queuePercentageGauge.setValue((double)Math.round(100.0 * (double)data.size() / (double)MetricsPersistentMinWorker.this.queueTotalSize));
            MetricsPersistentMinWorker.this.onWork(data);
        }

        public void onError(List<Metrics> data, Throwable t) {
            log.error(t.getMessage(), t);
        }
    }
}

