/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.management.ui.template;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.core.query.type.TemplateChangeStatus;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class UITemplateManagementService
implements Service {
    private final ModuleManager moduleManager;
    private UITemplateManagementDAO uiTemplateManagementDAO;

    private UITemplateManagementDAO getUITemplateManagementDAO() {
        if (this.uiTemplateManagementDAO == null) {
            this.uiTemplateManagementDAO = (UITemplateManagementDAO)this.moduleManager.find("storage").provider().getService(UITemplateManagementDAO.class);
        }
        return this.uiTemplateManagementDAO;
    }

    public DashboardConfiguration getTemplate(String id) throws IOException {
        DashboardConfiguration configuration = this.getUITemplateManagementDAO().getTemplate(id);
        if (configuration.isDisabled()) {
            return null;
        }
        return configuration;
    }

    public List<DashboardConfiguration> getAllTemplates(Boolean includingDisabled) throws IOException {
        List<DashboardConfiguration> allTemplates = this.getUITemplateManagementDAO().getAllTemplates(includingDisabled);
        return allTemplates;
    }

    public TemplateChangeStatus addTemplate(DashboardSetting setting) throws IOException {
        return this.getUITemplateManagementDAO().addTemplate(setting);
    }

    public TemplateChangeStatus changeTemplate(DashboardSetting setting) throws IOException {
        return this.getUITemplateManagementDAO().changeTemplate(setting);
    }

    public TemplateChangeStatus disableTemplate(String id) throws IOException {
        return this.getUITemplateManagementDAO().disableTemplate(id);
    }

    public void addIfNotExist(DashboardSetting setting) throws IOException {
        DashboardConfiguration configuration = this.getUITemplateManagementDAO().getTemplate(setting.getId());
        if (configuration == null) {
            this.getUITemplateManagementDAO().addTemplate(setting);
        }
    }

    @Generated
    public UITemplateManagementService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

