/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.asyncprofiler;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.storage.JFRProfilingDataRecord;
import org.apache.skywalking.oap.server.core.query.AsyncProfilerTaskLog;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerStackTree;
import org.apache.skywalking.oap.server.core.query.type.AsyncProfilerTask;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskLogQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IAsyncProfilerTaskQueryDAO;
import org.apache.skywalking.oap.server.core.storage.profiling.asyncprofiler.IJFRDataQueryDAO;
import org.apache.skywalking.oap.server.library.jfr.parser.JFRMergeBuilder;
import org.apache.skywalking.oap.server.library.jfr.type.FrameTree;
import org.apache.skywalking.oap.server.library.jfr.type.JFREventType;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;

public class AsyncProfilerQueryService
implements Service {
    private static final Gson GSON = new Gson();
    private final ModuleManager moduleManager;
    private IAsyncProfilerTaskQueryDAO taskQueryDAO;
    private IJFRDataQueryDAO dataQueryDAO;
    private IAsyncProfilerTaskLogQueryDAO logQueryDAO;

    private IAsyncProfilerTaskQueryDAO getTaskQueryDAO() {
        if (this.taskQueryDAO == null) {
            this.taskQueryDAO = (IAsyncProfilerTaskQueryDAO)this.moduleManager.find("storage").provider().getService(IAsyncProfilerTaskQueryDAO.class);
        }
        return this.taskQueryDAO;
    }

    private IJFRDataQueryDAO getJFRDataQueryDAO() {
        if (this.dataQueryDAO == null) {
            this.dataQueryDAO = (IJFRDataQueryDAO)this.moduleManager.find("storage").provider().getService(IJFRDataQueryDAO.class);
        }
        return this.dataQueryDAO;
    }

    private IAsyncProfilerTaskLogQueryDAO getTaskLogQueryDAO() {
        if (this.logQueryDAO == null) {
            this.logQueryDAO = (IAsyncProfilerTaskLogQueryDAO)this.moduleManager.find("storage").provider().getService(IAsyncProfilerTaskLogQueryDAO.class);
        }
        return this.logQueryDAO;
    }

    public List<AsyncProfilerTask> queryTask(String serviceId, Duration duration, Integer limit) throws IOException {
        Long startTimeBucket = null;
        Long endTimeBucket = null;
        if (Objects.nonNull(duration)) {
            startTimeBucket = duration.getStartTimeBucketInSec();
            endTimeBucket = duration.getEndTimeBucketInSec();
        }
        return this.getTaskQueryDAO().getTaskList(serviceId, startTimeBucket, endTimeBucket, limit);
    }

    public AsyncProfilerStackTree queryJFRData(String taskId, List<String> instanceIds, JFREventType eventType) throws IOException {
        List<JFRProfilingDataRecord> jfrDataList = this.getJFRDataQueryDAO().getByTaskIdAndInstancesAndEvent(taskId, instanceIds, eventType.name());
        List trees = jfrDataList.stream().map(data -> (FrameTree)GSON.fromJson(new String(data.getDataBinary()), FrameTree.class)).collect(Collectors.toList());
        FrameTree resultTree = new JFRMergeBuilder().merge(trees).build();
        return new AsyncProfilerStackTree(eventType, resultTree);
    }

    public List<AsyncProfilerTaskLog> queryAsyncProfilerTaskLogs(String taskId) throws IOException {
        List<AsyncProfilerTaskLog> taskLogList = this.getTaskLogQueryDAO().getTaskLogList();
        return this.findMatchedLogs(taskId, taskLogList);
    }

    private List<AsyncProfilerTaskLog> findMatchedLogs(String taskID, List<AsyncProfilerTaskLog> allLogs) {
        return allLogs.stream().filter(l -> Objects.equals(l.getId(), taskID)).map(this::extendTaskLog).collect(Collectors.toList());
    }

    private AsyncProfilerTaskLog extendTaskLog(AsyncProfilerTaskLog log) {
        IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId(log.getInstanceId());
        log.setInstanceName(instanceIDDefinition.getName());
        return log;
    }

    @Generated
    public AsyncProfilerQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

