/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.query.EndpointTopologyBuilder;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.core.query.ProcessTopologyBuilder;
import org.apache.skywalking.oap.server.core.query.ServiceInstanceTopologyBuilder;
import org.apache.skywalking.oap.server.core.query.ServiceTopologyBuilder;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.Call;
import org.apache.skywalking.oap.server.core.query.type.EndpointTopology;
import org.apache.skywalking.oap.server.core.query.type.Node;
import org.apache.skywalking.oap.server.core.query.type.ProcessTopology;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstanceTopology;
import org.apache.skywalking.oap.server.core.query.type.Topology;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.model.StorageModels;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyQueryService
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopologyQueryService.class);
    private final ModuleManager moduleManager;
    private final StorageModels storageModels;
    private ITopologyQueryDAO topologyQueryDAO;
    private IComponentLibraryCatalogService componentLibraryCatalogService;
    private MetadataQueryService metadataQueryService;

    public TopologyQueryService(ModuleManager moduleManager, StorageModels storageModels) {
        this.moduleManager = moduleManager;
        this.storageModels = storageModels;
    }

    private ITopologyQueryDAO getTopologyQueryDAO() {
        if (this.topologyQueryDAO == null) {
            this.topologyQueryDAO = (ITopologyQueryDAO)this.moduleManager.find("storage").provider().getService(ITopologyQueryDAO.class);
        }
        return this.topologyQueryDAO;
    }

    private MetadataQueryService getMetadataQueryService() {
        if (this.metadataQueryService == null) {
            this.metadataQueryService = (MetadataQueryService)this.moduleManager.find("core").provider().getService(MetadataQueryService.class);
        }
        return this.metadataQueryService;
    }

    private IComponentLibraryCatalogService getComponentLibraryCatalogService() {
        if (this.componentLibraryCatalogService == null) {
            this.componentLibraryCatalogService = (IComponentLibraryCatalogService)this.moduleManager.find("core").provider().getService(IComponentLibraryCatalogService.class);
        }
        return this.componentLibraryCatalogService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topology getGlobalTopology(Duration duration, String layer) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Service: getGlobalTopology");
                span.setMsg("Duration: " + String.valueOf(duration) + ", Layer: " + layer);
            }
            Topology topology = this.invokeGetGlobalTopology(duration, layer);
            return topology;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    private Topology invokeGetGlobalTopology(Duration duration, String layer) throws IOException {
        if (StringUtil.isNotEmpty((String)layer)) {
            List<String> serviceIdList = Optional.ofNullable(this.getMetadataQueryService().listServices(layer, null)).map(list -> list.stream().map(s -> s.getId()).collect(Collectors.toList())).orElse(Collections.emptyList());
            return this.getServiceTopology(duration, serviceIdList);
        }
        List<Call.CallDetail> serviceRelationServerCalls = this.getTopologyQueryDAO().loadServiceRelationsDetectedAtServerSideDebuggable(duration);
        List<Call.CallDetail> serviceRelationClientCalls = this.getTopologyQueryDAO().loadServiceRelationDetectedAtClientSideDebuggable(duration);
        ServiceTopologyBuilder builder = new ServiceTopologyBuilder(this.moduleManager);
        return builder.buildDebuggable(serviceRelationClientCalls, serviceRelationServerCalls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topology getServiceTopology(Duration duration, List<String> serviceIds) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Service: getServiceTopology");
                span.setMsg("Duration: " + String.valueOf(duration) + ", ServiceIds: " + String.valueOf(serviceIds));
            }
            if (CollectionUtils.isEmpty(serviceIds)) {
                Topology topology = new Topology();
                return topology;
            }
            Topology topology = this.invokeGetServiceTopology(duration, serviceIds);
            return topology;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    private Topology invokeGetServiceTopology(Duration duration, List<String> serviceIds) throws IOException {
        List<Call.CallDetail> serviceRelationClientCalls = this.getTopologyQueryDAO().loadServiceRelationDetectedAtClientSideDebuggable(duration, serviceIds);
        List<Call.CallDetail> serviceRelationServerCalls = this.getTopologyQueryDAO().loadServiceRelationsDetectedAtServerSideDebuggable(duration, serviceIds);
        ServiceTopologyBuilder builder = new ServiceTopologyBuilder(this.moduleManager);
        Topology topology = builder.buildDebuggable(serviceRelationClientCalls, serviceRelationServerCalls);
        ArrayList<String> outScopeSourceServiceIds = new ArrayList<String>();
        serviceRelationClientCalls.forEach(call -> {
            if (!serviceIds.contains(call.getSource())) {
                outScopeSourceServiceIds.add(call.getSource());
            }
        });
        if (CollectionUtils.isNotEmpty(outScopeSourceServiceIds)) {
            List<Call.CallDetail> sourceCalls = this.getTopologyQueryDAO().loadServiceRelationsDetectedAtServerSideDebuggable(duration, outScopeSourceServiceIds);
            topology.getNodes().forEach(node -> {
                if (Strings.isNullOrEmpty((String)node.getType())) {
                    for (Call.CallDetail call : sourceCalls) {
                        if (!node.getId().equals(call.getTarget())) continue;
                        node.setType(this.getComponentLibraryCatalogService().getComponentName(call.getComponentId()));
                        break;
                    }
                }
            });
        }
        return topology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInstanceTopology getServiceInstanceTopology(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Service: getServiceInstanceTopology");
                span.setMsg("ClientServiceId: " + clientServiceId + ", ServerServiceId: " + serverServiceId + ", Duration: " + String.valueOf(duration));
            }
            ServiceInstanceTopology serviceInstanceTopology = this.invokeGetServiceInstanceTopology(clientServiceId, serverServiceId, duration);
            return serviceInstanceTopology;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    private ServiceInstanceTopology invokeGetServiceInstanceTopology(String clientServiceId, String serverServiceId, Duration duration) throws IOException {
        List<Call.CallDetail> serviceInstanceRelationClientCalls = this.getTopologyQueryDAO().loadInstanceRelationDetectedAtClientSideDebuggable(clientServiceId, serverServiceId, duration);
        List<Call.CallDetail> serviceInstanceRelationServerCalls = this.getTopologyQueryDAO().loadInstanceRelationDetectedAtServerSideDebuggable(clientServiceId, serverServiceId, duration);
        ServiceInstanceTopologyBuilder builder = new ServiceInstanceTopologyBuilder(this.moduleManager);
        return builder.build(serviceInstanceRelationClientCalls, serviceInstanceRelationServerCalls);
    }

    @Deprecated
    public Topology getEndpointTopology(Duration duration, String endpointId) throws IOException {
        List<Call.CallDetail> serverSideCalls = this.getTopologyQueryDAO().loadEndpointRelation(duration, endpointId);
        Topology topology = new Topology();
        serverSideCalls.forEach(callDetail -> {
            Call call = new Call();
            call.setId(callDetail.getId());
            call.setSource(callDetail.getSource());
            call.setTarget(callDetail.getTarget());
            call.addDetectPoint(DetectPoint.SERVER);
            topology.getCalls().add(call);
        });
        HashSet nodeIds = new HashSet();
        serverSideCalls.forEach(call -> {
            if (!nodeIds.contains(call.getSource())) {
                topology.getNodes().add(this.buildEndpointNode(call.getSource()));
                nodeIds.add(call.getSource());
            }
            if (!nodeIds.contains(call.getTarget())) {
                topology.getNodes().add(this.buildEndpointNode(call.getTarget()));
                nodeIds.add(call.getTarget());
            }
        });
        return topology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointTopology getEndpointDependencies(Duration duration, String endpointId) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Service: getEndpointDependencies");
                span.setMsg("Duration: " + String.valueOf(duration) + ", EndpointId: " + endpointId);
            }
            EndpointTopology endpointTopology = this.invokeGetEndpointDependencies(duration, endpointId);
            return endpointTopology;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    private EndpointTopology invokeGetEndpointDependencies(Duration duration, String endpointId) throws IOException {
        List<Call.CallDetail> serverSideCalls = this.getTopologyQueryDAO().loadEndpointRelationDebuggable(duration, endpointId);
        EndpointTopologyBuilder builder = new EndpointTopologyBuilder();
        return builder.build(serverSideCalls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessTopology getProcessTopology(String instanceId, Duration duration) throws Exception {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Service: getProcessTopology");
                span.setMsg("InstanceId: " + instanceId + ", Duration: " + String.valueOf(duration));
            }
            ProcessTopology processTopology = this.invokeGetProcessTopology(instanceId, duration);
            return processTopology;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    private ProcessTopology invokeGetProcessTopology(String instanceId, Duration duration) throws Exception {
        List<Call.CallDetail> clientCalls = this.getTopologyQueryDAO().loadProcessRelationDetectedAtClientSideDebuggable(instanceId, duration);
        List<Call.CallDetail> serverCalls = this.getTopologyQueryDAO().loadProcessRelationDetectedAtServerSideDebuggable(instanceId, duration);
        ProcessTopologyBuilder topologyBuilder = new ProcessTopologyBuilder(this.moduleManager, this.storageModels);
        return topologyBuilder.build(clientCalls, serverCalls);
    }

    @Deprecated
    private Node buildEndpointNode(String endpointId) {
        Node node = new Node();
        node.setId(endpointId);
        IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId(endpointId);
        node.setName(endpointIDDefinition.getEndpointName());
        node.setType("");
        node.setReal(true);
        return node;
    }
}

