/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.enumeration;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;

public enum Scope {
    All(0),
    Service(1),
    ServiceInstance(2),
    Endpoint(3),
    ServiceRelation(4),
    ServiceInstanceRelation(5),
    EndpointRelation(6),
    Process(45),
    ProcessRelation(54);

    private int scopeId;

    private Scope(int scopeId) {
        this.scopeId = scopeId;
    }

    @Generated
    public int getScopeId() {
        return this.scopeId;
    }

    public static class Finder {
        public static Scope valueOf(int scopeId) {
            if (DefaultScopeDefine.inServiceCatalog(scopeId)) {
                return Service;
            }
            if (DefaultScopeDefine.inServiceInstanceCatalog(scopeId)) {
                return ServiceInstance;
            }
            if (DefaultScopeDefine.inEndpointCatalog(scopeId)) {
                return Endpoint;
            }
            if (DefaultScopeDefine.inServiceRelationCatalog(scopeId)) {
                return ServiceRelation;
            }
            if (DefaultScopeDefine.inServiceInstanceRelationCatalog(scopeId)) {
                return ServiceInstanceRelation;
            }
            if (DefaultScopeDefine.inEndpointRelationCatalog(scopeId)) {
                return EndpointRelation;
            }
            if (DefaultScopeDefine.inProcessCatalog(scopeId)) {
                return Process;
            }
            if (DefaultScopeDefine.inProcessRelationCatalog(scopeId)) {
                return ProcessRelation;
            }
            return All;
        }
    }
}

