/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.source.CiliumMetrics;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;

@ScopeDeclaration(id=80, name="CiliumServiceRelation", catalog="SERVICE_RELATION")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class CiliumServiceRelation
extends CiliumMetrics {
    private volatile String entityId;
    private String sourceServiceId;
    private String sourceServiceName;
    private Layer sourceLayer;
    private DetectPoint detectPoint;
    private int componentId;
    private String destServiceId;
    private String destServiceName;
    private Layer destLayer;

    @Override
    public int scope() {
        return 80;
    }

    @Override
    public void prepare() {
        this.sourceServiceId = IDManager.ServiceID.buildId(this.sourceServiceName, this.sourceLayer.isNormal());
        this.destServiceId = IDManager.ServiceID.buildId(this.destServiceName, this.destLayer.isNormal());
        this.entityId = IDManager.ServiceID.buildRelationId(new IDManager.ServiceID.ServiceRelationDefine(this.sourceServiceId, this.destServiceId));
    }

    @Generated
    public CiliumServiceRelation() {
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getSourceServiceId() {
        return this.sourceServiceId;
    }

    @Generated
    public String getSourceServiceName() {
        return this.sourceServiceName;
    }

    @Generated
    public Layer getSourceLayer() {
        return this.sourceLayer;
    }

    @Generated
    public DetectPoint getDetectPoint() {
        return this.detectPoint;
    }

    @Generated
    public int getComponentId() {
        return this.componentId;
    }

    @Generated
    public String getDestServiceId() {
        return this.destServiceId;
    }

    @Generated
    public String getDestServiceName() {
        return this.destServiceName;
    }

    @Generated
    public Layer getDestLayer() {
        return this.destLayer;
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setSourceServiceId(String sourceServiceId) {
        this.sourceServiceId = sourceServiceId;
    }

    @Generated
    public void setSourceServiceName(String sourceServiceName) {
        this.sourceServiceName = sourceServiceName;
    }

    @Generated
    public void setSourceLayer(Layer sourceLayer) {
        this.sourceLayer = sourceLayer;
    }

    @Generated
    public void setDetectPoint(DetectPoint detectPoint) {
        this.detectPoint = detectPoint;
    }

    @Generated
    public void setComponentId(int componentId) {
        this.componentId = componentId;
    }

    @Generated
    public void setDestServiceId(String destServiceId) {
        this.destServiceId = destServiceId;
    }

    @Generated
    public void setDestServiceName(String destServiceName) {
        this.destServiceName = destServiceName;
    }

    @Generated
    public void setDestLayer(Layer destLayer) {
        this.destLayer = destLayer;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CiliumServiceRelation)) {
            return false;
        }
        CiliumServiceRelation other = (CiliumServiceRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getComponentId() != other.getComponentId()) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        String this$sourceServiceId = this.getSourceServiceId();
        String other$sourceServiceId = other.getSourceServiceId();
        if (this$sourceServiceId == null ? other$sourceServiceId != null : !this$sourceServiceId.equals(other$sourceServiceId)) {
            return false;
        }
        String this$sourceServiceName = this.getSourceServiceName();
        String other$sourceServiceName = other.getSourceServiceName();
        if (this$sourceServiceName == null ? other$sourceServiceName != null : !this$sourceServiceName.equals(other$sourceServiceName)) {
            return false;
        }
        Layer this$sourceLayer = this.getSourceLayer();
        Layer other$sourceLayer = other.getSourceLayer();
        if (this$sourceLayer == null ? other$sourceLayer != null : !((Object)((Object)this$sourceLayer)).equals((Object)other$sourceLayer)) {
            return false;
        }
        DetectPoint this$detectPoint = this.getDetectPoint();
        DetectPoint other$detectPoint = other.getDetectPoint();
        if (this$detectPoint == null ? other$detectPoint != null : !((Object)((Object)this$detectPoint)).equals((Object)other$detectPoint)) {
            return false;
        }
        String this$destServiceId = this.getDestServiceId();
        String other$destServiceId = other.getDestServiceId();
        if (this$destServiceId == null ? other$destServiceId != null : !this$destServiceId.equals(other$destServiceId)) {
            return false;
        }
        String this$destServiceName = this.getDestServiceName();
        String other$destServiceName = other.getDestServiceName();
        if (this$destServiceName == null ? other$destServiceName != null : !this$destServiceName.equals(other$destServiceName)) {
            return false;
        }
        Layer this$destLayer = this.getDestLayer();
        Layer other$destLayer = other.getDestLayer();
        return !(this$destLayer == null ? other$destLayer != null : !((Object)((Object)this$destLayer)).equals((Object)other$destLayer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CiliumServiceRelation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getComponentId();
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        String $sourceServiceId = this.getSourceServiceId();
        result = result * 59 + ($sourceServiceId == null ? 43 : $sourceServiceId.hashCode());
        String $sourceServiceName = this.getSourceServiceName();
        result = result * 59 + ($sourceServiceName == null ? 43 : $sourceServiceName.hashCode());
        Layer $sourceLayer = this.getSourceLayer();
        result = result * 59 + ($sourceLayer == null ? 43 : ((Object)((Object)$sourceLayer)).hashCode());
        DetectPoint $detectPoint = this.getDetectPoint();
        result = result * 59 + ($detectPoint == null ? 43 : ((Object)((Object)$detectPoint)).hashCode());
        String $destServiceId = this.getDestServiceId();
        result = result * 59 + ($destServiceId == null ? 43 : $destServiceId.hashCode());
        String $destServiceName = this.getDestServiceName();
        result = result * 59 + ($destServiceName == null ? 43 : $destServiceName.hashCode());
        Layer $destLayer = this.getDestLayer();
        result = result * 59 + ($destLayer == null ? 43 : ((Object)((Object)$destLayer)).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "CiliumServiceRelation(entityId=" + this.getEntityId() + ", sourceServiceId=" + this.getSourceServiceId() + ", sourceServiceName=" + this.getSourceServiceName() + ", sourceLayer=" + String.valueOf((Object)this.getSourceLayer()) + ", detectPoint=" + String.valueOf((Object)this.getDetectPoint()) + ", componentId=" + this.getComponentId() + ", destServiceId=" + this.getDestServiceId() + ", destServiceName=" + this.getDestServiceName() + ", destLayer=" + String.valueOf((Object)this.getDestLayer()) + ")";
    }
}

