/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.source;

import com.google.gson.JsonObject;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.query.enumeration.ProfilingSupportStatus;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.source.ScopeDefaultColumn;
import org.apache.skywalking.oap.server.core.source.Source;

@ScopeDeclaration(id=45, name="Process", catalog="PROCESS")
@ScopeDefaultColumn.VirtualColumnDefinition(fieldName="entityId", columnName="entity_id", isID=true, type=String.class)
public class Process
extends Source {
    private volatile String entityId;
    private String instanceId;
    private String serviceId;
    private String name;
    private String serviceName;
    private String instanceName;
    private boolean isServiceNormal;
    private String agentId;
    private ProcessDetectType detectType;
    private JsonObject properties;
    private List<String> labels;
    private ProfilingSupportStatus profilingSupportStatus;

    @Override
    public int scope() {
        return 45;
    }

    @Override
    public String getEntityId() {
        if (this.entityId == null) {
            this.entityId = IDManager.ProcessID.buildId(this.instanceId, this.name);
        }
        return this.entityId;
    }

    @Override
    public void prepare() {
        this.serviceId = IDManager.ServiceID.buildId(this.serviceName, this.isServiceNormal);
        this.instanceId = IDManager.ServiceInstanceID.buildId(this.serviceId, this.instanceName);
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getInstanceName() {
        return this.instanceName;
    }

    @Generated
    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @Generated
    public boolean isServiceNormal() {
        return this.isServiceNormal;
    }

    @Generated
    public void setServiceNormal(boolean isServiceNormal) {
        this.isServiceNormal = isServiceNormal;
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public ProcessDetectType getDetectType() {
        return this.detectType;
    }

    @Generated
    public void setDetectType(ProcessDetectType detectType) {
        this.detectType = detectType;
    }

    @Generated
    public JsonObject getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(JsonObject properties) {
        this.properties = properties;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public void setProfilingSupportStatus(ProfilingSupportStatus profilingSupportStatus) {
        this.profilingSupportStatus = profilingSupportStatus;
    }

    @Generated
    public ProfilingSupportStatus getProfilingSupportStatus() {
        return this.profilingSupportStatus;
    }
}

