/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.model;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;

public class ElasticSearchModelExtension {
    private Optional<String> routing = Optional.empty();

    public void setRouting(String modelName, List<ModelColumn> modelColumns) throws IllegalStateException {
        if (CollectionUtils.isEmpty(modelColumns)) {
            return;
        }
        List routingColumns = modelColumns.stream().filter(col -> col.getElasticSearchExtension().isRouting()).collect(Collectors.toList());
        int size = routingColumns.size();
        if (size > 1) {
            throw new IllegalStateException(modelName + "'s routing field is duplicated " + routingColumns.stream().map(col -> col.getColumnName().toString()).collect(Collectors.joining(",", "[", "]")));
        }
        if (size == 1) {
            this.routing = Optional.of(((ModelColumn)routingColumns.get(0)).getColumnName().getName());
        }
    }

    @Generated
    public Optional<String> getRouting() {
        return this.routing;
    }
}

