/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SWSpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventTraceType;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.Service;

public interface ISpanAttachedEventQueryDAO
extends Service {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<SWSpanAttachedEventRecord> querySWSpanAttachedEventsDebuggable(SpanAttachedEventTraceType type, List<String> traceIds, @Nullable Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            StringBuilder builder = new StringBuilder();
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: querySWSpanAttachedEvents");
                builder.append("Condition: Span Type: ").append((Object)type).append(", TraceIds: ").append(traceIds);
                span.setMsg(builder.toString());
            }
            List<SWSpanAttachedEventRecord> list = this.querySWSpanAttachedEvents(traceIds, duration);
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            return list;
        }
        catch (Throwable throwable) {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<SpanAttachedEventRecord> queryZKSpanAttachedEventsDebuggable(SpanAttachedEventTraceType type, List<String> traceIds, @Nullable Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            StringBuilder builder = new StringBuilder();
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: queryZKSpanAttachedEvents");
                builder.append("Condition: Span Type: ").append((Object)type).append(", TraceIds: ").append(traceIds);
                span.setMsg(builder.toString());
            }
            List<SpanAttachedEventRecord> list = this.queryZKSpanAttachedEvents(traceIds, duration);
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            return list;
        }
        catch (Throwable throwable) {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            throw throwable;
        }
    }

    public List<SWSpanAttachedEventRecord> querySWSpanAttachedEvents(List<String> var1, @Nullable Duration var2) throws IOException;

    public List<SpanAttachedEventRecord> queryZKSpanAttachedEvents(List<String> var1, @Nullable Duration var2) throws IOException;
}

