/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.storage.query;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.DAO;
import zipkin2.Span;
import zipkin2.storage.QueryRequest;

public interface IZipkinQueryDAO
extends DAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<List<Span>> getTracesDebuggable(QueryRequest request, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            StringBuilder builder = new StringBuilder();
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: getTraces");
                builder.append("Condition: Request: ").append(request).append(", Duration: ").append(duration);
                span.setMsg(builder.toString());
            }
            List<List<Span>> list = this.getTraces(request, duration);
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            return list;
        }
        catch (Throwable throwable) {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<Span> getTraceDebuggable(String traceId, @Nullable Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Dao: getTrace");
                span.setMsg("Condition: TraceId: " + traceId);
            }
            List<Span> list = this.getTrace(traceId, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }

    public List<String> getServiceNames() throws IOException;

    public List<String> getRemoteServiceNames(String var1) throws IOException;

    public List<String> getSpanNames(String var1) throws IOException;

    public List<Span> getTrace(String var1, @Nullable Duration var2) throws IOException;

    public List<List<Span>> getTraces(QueryRequest var1, Duration var2) throws IOException;

    public List<List<Span>> getTraces(Set<String> var1, @Nullable Duration var2) throws IOException;
}

