/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.tool.profile.exporter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadSnapshot;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadStack;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileThreadSnapshotRecord;
import org.apache.skywalking.oap.server.core.query.input.SegmentProfileAnalyzeQuery;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileThreadSnapshotQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.tool.profile.exporter.ProfiledBasicInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileSnapshotDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfileSnapshotDumper.class);
    public static final int QUERY_PROFILE_SNAPSHOT_RETRY_COUNT = 3;
    public static final int QUERY_PROFILE_WRITE_PROCESS_LOG = 3;

    public static File dump(ProfiledBasicInfo basicInfo, ModuleManager manager) throws IOException {
        IProfileThreadSnapshotQueryDAO snapshotQueryDAO = (IProfileThreadSnapshotQueryDAO)manager.find("storage").provider().getService(IProfileThreadSnapshotQueryDAO.class);
        List<ProfiledBasicInfo.SequenceRange> sequenceRanges = basicInfo.buildSequenceRanges();
        int rangeCount = sequenceRanges.size();
        File snapshotFile = new File(basicInfo.getConfig().getAnalyzeResultDist() + File.separator + "snapshot.data");
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(snapshotFile));){
            for (int i = 0; i < rangeCount; ++i) {
                List<ProfileThreadSnapshotRecord> records = ProfileSnapshotDumper.querySnapshot(snapshotQueryDAO, sequenceRanges.get(i));
                for (ProfileThreadSnapshotRecord record : records) {
                    ThreadSnapshot.newBuilder().setStack(ThreadStack.parseFrom((byte[])record.getStackBinary())).setSequence(record.getSequence()).setTime(record.getDumpTime()).build().writeDelimitedTo((OutputStream)outputStream);
                }
                if ((i <= 0 || i % 3 != 0) && i != rangeCount - 1) continue;
                log.info("Dump snapshots process:[{}/{}]:{}%", new Object[]{i + 1, rangeCount, (int)((double)(i + 1) / (double)rangeCount * 100.0)});
            }
        }
        return snapshotFile;
    }

    private static List<ProfileThreadSnapshotRecord> querySnapshot(IProfileThreadSnapshotQueryDAO threadSnapshotQueryDAO, ProfiledBasicInfo.SequenceRange sequenceRange) throws IOException {
        for (int i = 1; i <= 3; ++i) {
            try {
                return threadSnapshotQueryDAO.queryRecords(sequenceRange.getSegmentId(), sequenceRange.getMin(), sequenceRange.getMax());
            }
            catch (IOException e) {
                if (i != 3) continue;
                throw e;
            }
        }
        return null;
    }

    public static List<ThreadSnapshot> parseFromFileWithTimeRange(File file, List<SegmentProfileAnalyzeQuery> queries) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            ThreadSnapshot snapshot;
            ArrayList<ThreadSnapshot> data = new ArrayList<ThreadSnapshot>();
            while ((snapshot = ThreadSnapshot.parseDelimitedFrom((InputStream)fileInputStream)) != null) {
                ThreadSnapshot finalSnapshot = snapshot;
                if (!queries.stream().anyMatch(t -> finalSnapshot.getTime() >= t.getTimeRange().getStart() && finalSnapshot.getTime() <= t.getTimeRange().getEnd())) continue;
                data.add(snapshot);
            }
            ArrayList<ThreadSnapshot> arrayList = data;
            return arrayList;
        }
    }
}

