/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.grpc;

import com.linecorp.armeria.client.AbstractClientOptionsBuilder;
import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.HttpPreprocessor;
import com.linecorp.armeria.client.ResponseTimeoutMode;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.RpcPreprocessor;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.grpc.GrpcClientOptions;
import com.linecorp.armeria.client.grpc.GrpcClientStubFactory;
import com.linecorp.armeria.client.redirect.RedirectConfig;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.grpc.CallCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Compressor;
import io.grpc.DecompressorRegistry;
import io.grpc.ServiceDescriptor;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@UnstableApi
public final class GrpcClientBuilder
extends AbstractClientOptionsBuilder {
    private final ImmutableList.Builder<ClientInterceptor> interceptors = ImmutableList.builder();
    @Nullable
    private final EndpointGroup endpointGroup;
    @Nullable
    private URI uri;
    @Nullable
    private String prefix;
    private Scheme scheme;
    @Nullable
    private GrpcExceptionHandlerFunction exceptionHandler;

    GrpcClientBuilder(URI uri) {
        Objects.requireNonNull(uri, "uri");
        Preconditions.checkArgument((uri.getScheme() != null ? 1 : 0) != 0, (String)"uri must have scheme: %s", (Object)uri);
        this.endpointGroup = null;
        this.uri = uri;
        this.scheme = Scheme.parse((String)uri.getScheme());
        this.validateOrSetSerializationFormat();
    }

    GrpcClientBuilder(Scheme scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        this.uri = null;
        this.scheme = scheme;
        this.validateOrSetSerializationFormat();
        this.endpointGroup = endpointGroup;
    }

    private void validateOrSetSerializationFormat() {
        if (this.scheme.serializationFormat() == SerializationFormat.NONE) {
            this.serializationFormat(GrpcSerializationFormats.PROTO);
        } else {
            GrpcClientBuilder.ensureGrpcSerializationFormat(this.scheme.serializationFormat());
        }
    }

    public GrpcClientBuilder serializationFormat(SerializationFormat serializationFormat) {
        Objects.requireNonNull(serializationFormat, "serializationFormat");
        GrpcClientBuilder.ensureGrpcSerializationFormat(serializationFormat);
        this.scheme = Scheme.of((SerializationFormat)serializationFormat, (SessionProtocol)this.scheme.sessionProtocol());
        if (this.uri != null) {
            String rawUri = this.uri.toString();
            this.uri = URI.create(this.scheme + rawUri.substring(rawUri.indexOf(58)));
        }
        return this;
    }

    private static void ensureGrpcSerializationFormat(SerializationFormat serializationFormat) {
        Preconditions.checkArgument((boolean)GrpcSerializationFormats.isGrpc(serializationFormat), (String)"serializationFormat: %s (expected: one of %s)", (Object)serializationFormat, GrpcSerializationFormats.values());
    }

    @Deprecated
    public GrpcClientBuilder path(String prefix) {
        return this.pathPrefix(prefix);
    }

    public GrpcClientBuilder pathPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0, (Object)"prefix is empty.");
        Preconditions.checkArgument((prefix.charAt(0) == '/' ? 1 : 0) != 0, (String)"prefix: %s (must start with '/')", (Object)prefix);
        if (!prefix.endsWith("/")) {
            prefix = prefix + '/';
        }
        this.prefix = prefix;
        return this;
    }

    public GrpcClientBuilder maxRequestMessageLength(int maxRequestMessageLength) {
        Preconditions.checkArgument((maxRequestMessageLength >= -1 ? 1 : 0) != 0, (String)"maxRequestMessageLength: %s (expected: >= -1)", (int)maxRequestMessageLength);
        return this.option((ClientOptionValue)GrpcClientOptions.MAX_OUTBOUND_MESSAGE_SIZE_BYTES.newValue((Object)maxRequestMessageLength));
    }

    public GrpcClientBuilder maxResponseMessageLength(int maxResponseMessageLength) {
        Preconditions.checkArgument((maxResponseMessageLength >= -1 ? 1 : 0) != 0, (String)"maxResponseMessageLength: %s (expected: >= -1)", (int)maxResponseMessageLength);
        return this.option((ClientOptionValue)GrpcClientOptions.MAX_INBOUND_MESSAGE_SIZE_BYTES.newValue((Object)maxResponseMessageLength));
    }

    public GrpcClientBuilder compressor(Compressor compressor) {
        Objects.requireNonNull(compressor, "compressor");
        return this.option((ClientOptionValue)GrpcClientOptions.COMPRESSOR.newValue((Object)compressor));
    }

    public GrpcClientBuilder decompressorRegistry(DecompressorRegistry registry) {
        Objects.requireNonNull(registry, "registry");
        return this.option((ClientOptionValue)GrpcClientOptions.DECOMPRESSOR_REGISTRY.newValue((Object)registry));
    }

    public GrpcClientBuilder callCredentials(CallCredentials callCredentials) {
        Objects.requireNonNull(callCredentials, "callCredentials");
        return this.option((ClientOptionValue)GrpcClientOptions.CALL_CREDENTIALS.newValue((Object)callCredentials));
    }

    @UnstableApi
    public GrpcClientBuilder enableUnsafeWrapResponseBuffers(boolean enableUnsafeWrapResponseBuffers) {
        ClientOptions options = this.buildOptions();
        if (((Boolean)options.get(GrpcClientOptions.USE_METHOD_MARSHALLER)).booleanValue()) {
            throw new IllegalStateException("'unsafeWrapRequestBuffers' and 'useMethodMarshaller' are mutually exclusive.");
        }
        return this.option((ClientOptionValue)GrpcClientOptions.UNSAFE_WRAP_RESPONSE_BUFFERS.newValue((Object)enableUnsafeWrapResponseBuffers));
    }

    @UnstableApi
    public GrpcClientBuilder useMethodMarshaller(boolean useMethodMarshaller) {
        ClientOptions options = this.buildOptions();
        if (((Boolean)options.get(GrpcClientOptions.UNSAFE_WRAP_RESPONSE_BUFFERS)).booleanValue()) {
            throw new IllegalStateException("'unsafeWrapRequestBuffers' and 'useMethodMarshaller' are mutually exclusive.");
        }
        return this.option((ClientOptionValue)GrpcClientOptions.USE_METHOD_MARSHALLER.newValue((Object)useMethodMarshaller));
    }

    public GrpcClientBuilder jsonMarshallerFactory(Function<? super ServiceDescriptor, ? extends GrpcJsonMarshaller> jsonMarshallerFactory) {
        Objects.requireNonNull(jsonMarshallerFactory, "jsonMarshallerFactory");
        return this.option((ClientOptionValue)GrpcClientOptions.GRPC_JSON_MARSHALLER_FACTORY.newValue(jsonMarshallerFactory));
    }

    public GrpcClientBuilder clientStubFactory(GrpcClientStubFactory clientStubFactory) {
        Objects.requireNonNull(clientStubFactory, "clientStubFactory");
        return this.option((ClientOptionValue)GrpcClientOptions.GRPC_CLIENT_STUB_FACTORY.newValue((Object)clientStubFactory));
    }

    public GrpcClientBuilder intercept(ClientInterceptor ... interceptors) {
        Objects.requireNonNull(interceptors, "interceptors");
        return this.intercept((Iterable<? extends ClientInterceptor>)ImmutableList.copyOf((Object[])interceptors));
    }

    public GrpcClientBuilder intercept(Iterable<? extends ClientInterceptor> interceptors) {
        Objects.requireNonNull(interceptors, "interceptors");
        this.interceptors.addAll(interceptors);
        return this;
    }

    @Deprecated
    public GrpcClientBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        throw new UnsupportedOperationException("rpcDecorator() does not support gRPC. Use either decorator() or intercept()");
    }

    @Deprecated
    public GrpcClientBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        throw new UnsupportedOperationException("rpcDecorator() does not support gRPC. Use either decorator() or intercept()");
    }

    public <T> T build(Class<T> clientType) {
        Object client;
        Objects.requireNonNull(clientType, "clientType");
        ImmutableList clientInterceptors = this.interceptors.build();
        if (!clientInterceptors.isEmpty()) {
            this.option((ClientOptionValue)GrpcClientOptions.INTERCEPTORS.newValue((Object)clientInterceptors));
        }
        if (this.exceptionHandler != null) {
            this.option((ClientOptionValue)GrpcClientOptions.EXCEPTION_HANDLER.newValue((Object)this.exceptionHandler.orElse(GrpcExceptionHandlerFunction.of())));
        }
        ClientOptions options = this.buildOptions();
        ClientFactory factory = options.factory();
        URI uri = this.uri;
        if (uri != null) {
            if (this.prefix != null) {
                uri = uri.resolve(this.prefix);
            }
            client = factory.newClient(ClientBuilderParams.of((URI)uri, clientType, (ClientOptions)options));
        } else {
            assert (this.endpointGroup != null);
            client = factory.newClient(ClientBuilderParams.of((Scheme)this.scheme, (EndpointGroup)this.endpointGroup, (String)this.prefix, clientType, (ClientOptions)options));
        }
        Object cast = client;
        return (T)cast;
    }

    public GrpcClientBuilder options(ClientOptions options) {
        return (GrpcClientBuilder)super.options(options);
    }

    public GrpcClientBuilder options(ClientOptionValue<?> ... options) {
        return (GrpcClientBuilder)super.options(options);
    }

    public GrpcClientBuilder options(Iterable<ClientOptionValue<?>> options) {
        return (GrpcClientBuilder)super.options(options);
    }

    public <T> GrpcClientBuilder option(ClientOption<T> option, T value) {
        return (GrpcClientBuilder)super.option(option, value);
    }

    public <T> GrpcClientBuilder option(ClientOptionValue<T> optionValue) {
        return (GrpcClientBuilder)super.option(optionValue);
    }

    public GrpcClientBuilder factory(ClientFactory factory) {
        return (GrpcClientBuilder)super.factory(factory);
    }

    public GrpcClientBuilder writeTimeout(Duration writeTimeout) {
        return (GrpcClientBuilder)super.writeTimeout(writeTimeout);
    }

    public GrpcClientBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        return (GrpcClientBuilder)super.writeTimeoutMillis(writeTimeoutMillis);
    }

    public GrpcClientBuilder responseTimeout(Duration responseTimeout) {
        return (GrpcClientBuilder)super.responseTimeout(responseTimeout);
    }

    public GrpcClientBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        return (GrpcClientBuilder)super.responseTimeoutMillis(responseTimeoutMillis);
    }

    public GrpcClientBuilder maxResponseLength(long maxResponseLength) {
        return (GrpcClientBuilder)super.maxResponseLength(maxResponseLength);
    }

    public GrpcClientBuilder requestAutoAbortDelay(Duration delay) {
        return (GrpcClientBuilder)super.requestAutoAbortDelay(delay);
    }

    public GrpcClientBuilder requestAutoAbortDelayMillis(long delayMillis) {
        return (GrpcClientBuilder)super.requestAutoAbortDelayMillis(delayMillis);
    }

    public GrpcClientBuilder requestIdGenerator(Supplier<RequestId> requestIdGenerator) {
        return (GrpcClientBuilder)super.requestIdGenerator(requestIdGenerator);
    }

    public GrpcClientBuilder successFunction(SuccessFunction successFunction) {
        return (GrpcClientBuilder)super.successFunction(successFunction);
    }

    public GrpcClientBuilder endpointRemapper(Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper) {
        return (GrpcClientBuilder)super.endpointRemapper(endpointRemapper);
    }

    public GrpcClientBuilder decorator(Function<? super HttpClient, ? extends HttpClient> decorator) {
        return (GrpcClientBuilder)super.decorator(decorator);
    }

    public GrpcClientBuilder decorator(DecoratingHttpClientFunction decorator) {
        return (GrpcClientBuilder)super.decorator(decorator);
    }

    public GrpcClientBuilder clearDecorators() {
        return (GrpcClientBuilder)super.clearDecorators();
    }

    public GrpcClientBuilder addHeader(CharSequence name, Object value) {
        return (GrpcClientBuilder)super.addHeader(name, value);
    }

    public GrpcClientBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (GrpcClientBuilder)super.addHeaders(headers);
    }

    public GrpcClientBuilder setHeader(CharSequence name, Object value) {
        return (GrpcClientBuilder)super.setHeader(name, value);
    }

    public GrpcClientBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (GrpcClientBuilder)super.setHeaders(headers);
    }

    public GrpcClientBuilder auth(BasicToken token) {
        return (GrpcClientBuilder)super.auth(token);
    }

    public GrpcClientBuilder auth(OAuth1aToken token) {
        return (GrpcClientBuilder)super.auth(token);
    }

    public GrpcClientBuilder auth(OAuth2Token token) {
        return (GrpcClientBuilder)super.auth(token);
    }

    public GrpcClientBuilder auth(AuthToken token) {
        return (GrpcClientBuilder)super.auth(token);
    }

    public GrpcClientBuilder followRedirects() {
        return (GrpcClientBuilder)super.followRedirects();
    }

    public GrpcClientBuilder followRedirects(RedirectConfig redirectConfig) {
        return (GrpcClientBuilder)super.followRedirects(redirectConfig);
    }

    public GrpcClientBuilder contextCustomizer(Consumer<? super ClientRequestContext> contextCustomizer) {
        return (GrpcClientBuilder)super.contextCustomizer(contextCustomizer);
    }

    public GrpcClientBuilder responseTimeoutMode(ResponseTimeoutMode responseTimeoutMode) {
        return (GrpcClientBuilder)super.responseTimeoutMode(responseTimeoutMode);
    }

    public GrpcClientBuilder preprocessor(HttpPreprocessor decorator) {
        return (GrpcClientBuilder)super.preprocessor(decorator);
    }

    @Deprecated
    public GrpcClientBuilder rpcPreprocessor(RpcPreprocessor decorator) {
        throw new UnsupportedOperationException("rpcPreprocessor() does not support gRPC. Use preprocessor() instead.");
    }

    public GrpcClientBuilder exceptionHandler(GrpcExceptionHandlerFunction exceptionHandler) {
        Objects.requireNonNull(exceptionHandler, "exceptionHandler");
        this.exceptionHandler = this.exceptionHandler == null ? exceptionHandler : this.exceptionHandler.orElse(exceptionHandler);
        return this;
    }
}

